/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item;

import com.emc.mongoose.base.data.DataCorruptionException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.data.DataSizeException;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.ItemImpl;
import com.emc.mongoose.base.item.io.AsyncChannel;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class DataItemImpl
extends ItemImpl
implements DataItem {
    private static final String FMT_MSG_OFFSET = "Data item offset is not correct hexadecimal value: \"%s\"";
    private static final String FMT_MSG_SIZE = "Data item size is not correct hexadecimal value: \"%s\"";
    private static final String FMT_MSG_MASK = "Ranges mask is not correct hexadecimal value: %s";
    private static final String STR_EMPTY_MASK = "0";
    private static final char LAYER_MASK_SEP = '/';
    private volatile DataInput dataInput;
    private int dataInputSize;
    protected int layerNum = 0;
    protected long offset = 0L;
    protected long position = 0L;
    protected long size = 0L;
    protected final BitSet modifiedRangesMask = new BitSet(64);
    private static final ThreadLocal<StringBuilder> STRB = ThreadLocal.withInitial(StringBuilder::new);

    public DataItemImpl() {
    }

    public DataItemImpl(String value) throws IllegalArgumentException {
        this(value, value.indexOf(44));
    }

    private DataItemImpl(String value, int firstCommaPos) throws IllegalArgumentException {
        super(value.substring(0, firstCommaPos));
        int prevCommaPos = firstCommaPos;
        int nextCommaPos = value.indexOf(44, prevCommaPos + 1);
        if (nextCommaPos < prevCommaPos) {
            throw new IllegalArgumentException("Invalid data item description: " + value);
        }
        String offsetInfo = value.substring(prevCommaPos + 1, nextCommaPos);
        try {
            this.offset(Long.parseLong(offsetInfo, 16));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(FMT_MSG_OFFSET, offsetInfo));
        }
        prevCommaPos = nextCommaPos;
        nextCommaPos = value.indexOf(44, prevCommaPos + 1);
        if (nextCommaPos < prevCommaPos) {
            throw new IllegalArgumentException("Invalid data item description: " + value);
        }
        String sizeInfo = value.substring(prevCommaPos + 1, nextCommaPos);
        try {
            this.truncate(Long.parseLong(sizeInfo, 10));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(FMT_MSG_SIZE, sizeInfo));
        }
        prevCommaPos = nextCommaPos;
        String rangesInfo = value.substring(prevCommaPos + 1);
        int sepPos = rangesInfo.indexOf(47, 0);
        try {
            this.layerNum = Integer.parseInt(rangesInfo.substring(0, sepPos), 16);
            String rangesMask = rangesInfo.substring(sepPos + 1, rangesInfo.length());
            char[] rangesMaskChars = rangesMask.length() == 0 ? ("00" + rangesMask).toCharArray() : (rangesMask.length() % 2 == 1 ? (STR_EMPTY_MASK + rangesMask).toCharArray() : rangesMask.toCharArray());
            this.modifiedRangesMask.or(BitSet.valueOf(Hex.decodeHex(rangesMaskChars)));
        }
        catch (NumberFormatException | DecoderException e) {
            throw new IllegalArgumentException(String.format(FMT_MSG_MASK, rangesInfo));
        }
    }

    public DataItemImpl(long offset, long size) {
        this(Long.toString(offset, 36), offset, size, 0);
    }

    public DataItemImpl(String name, long offset, long size) {
        this(name, offset, size, 0);
    }

    public DataItemImpl(long offset, long size, int layerNum) {
        this();
        this.layerNum = layerNum;
        this.offset = offset;
        this.size = size;
    }

    public DataItemImpl(String name, long offset, long size, int layerNum) {
        super(name);
        this.layerNum = layerNum;
        this.offset = offset;
        this.size = size;
    }

    public DataItemImpl(DataItemImpl baseDataItem, long internalOffset, long size, boolean nextLayer) {
        this.dataInput = baseDataItem.dataInput;
        this.dataInputSize = baseDataItem.dataInputSize;
        this.offset = baseDataItem.offset + internalOffset;
        this.size = size;
        this.layerNum = nextLayer ? baseDataItem.layerNum : baseDataItem.layerNum;
    }

    @Override
    public String toString() {
        StringBuilder strb = STRB.get();
        strb.setLength(0);
        return strb.append(super.toString()).append(',').append(Long.toString(this.offset, 16)).append(',').append(this.size).append(',').append(Integer.toHexString(this.layerNum)).append('/').append(this.modifiedRangesMask.isEmpty() ? STR_EMPTY_MASK : Hex.encodeHexString(this.modifiedRangesMask.toByteArray())).toString();
    }

    @Override
    public String toString(String itemPath) {
        StringBuilder strBuilder = STRB.get();
        strBuilder.setLength(0);
        return strBuilder.append(super.toString(itemPath)).append(',').append(Long.toString(this.offset, 16)).append(',').append(this.size).append(',').append(Integer.toHexString(this.layerNum)).append('/').append(this.modifiedRangesMask.isEmpty() ? STR_EMPTY_MASK : Hex.encodeHexString(this.modifiedRangesMask.toByteArray())).toString();
    }

    @Override
    public final DataInput dataInput() {
        return this.dataInput;
    }

    @Override
    public final void dataInput(DataInput dataInput) {
        this.dataInput = dataInput;
        this.dataInputSize = dataInput.getSize();
    }

    @Override
    public void reset() {
        super.reset();
        this.position = 0L;
    }

    @Override
    public final int layer() {
        return this.layerNum;
    }

    @Override
    public final void layer(int layerNum) {
        this.layerNum = layerNum;
    }

    @Override
    public final void size(long size) {
        this.size = size;
    }

    @Override
    public final long offset() {
        return this.offset;
    }

    @Override
    public final void offset(long offset) {
        this.offset = offset < 0L ? Long.MAX_VALUE + offset + 1L : offset;
        this.position = 0L;
    }

    public DataItemImpl slice(long from, long partSize) {
        if (from < 0L) {
            throw new IllegalArgumentException();
        }
        if (partSize < 1L) {
            throw new IllegalArgumentException();
        }
        DataItemImpl dataItemSlice = new DataItemImpl(this.name(), this.offset + from, partSize, this.layerNum);
        DataInput dataInput = this.dataInput;
        if (dataInput != null) {
            dataItemSlice.dataInput(dataInput);
        }
        return dataItemSlice;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public final DataItemImpl position(long position) {
        this.position = position;
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public DataItemImpl truncate(long size) {
        this.size = size;
        return this;
    }

    @Override
    public final long rangeSize(int i) {
        return Math.min(DataItem.rangeOffset(i + 1), this.size) - DataItem.rangeOffset(i);
    }

    @Override
    public final boolean isUpdated() {
        return this.layerNum > 0 || !this.modifiedRangesMask.isEmpty();
    }

    @Override
    public final void commitUpdatedRanges(BitSet[] updatingRangesMaskPair) {
        if (updatingRangesMaskPair[1].isEmpty()) {
            this.modifiedRangesMask.or(updatingRangesMaskPair[0]);
        } else {
            this.modifiedRangesMask.clear();
            this.modifiedRangesMask.or(updatingRangesMaskPair[1]);
            ++this.layerNum;
        }
    }

    @Override
    public final boolean isRangeUpdated(int rangeIdx) {
        return this.modifiedRangesMask.get(rangeIdx);
    }

    @Override
    public final int updatedRangesCount() {
        return this.modifiedRangesMask.cardinality();
    }

    @Override
    public final void close() {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final int read(ByteBuffer dst) {
        MappedByteBuffer ringBuff = (MappedByteBuffer)this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        ringBuff.position((int)((this.offset + this.position) % (long)this.dataInputSize));
        int n = Math.min(dst.remaining(), ringBuff.remaining());
        ringBuff.limit(ringBuff.position() + n);
        dst.put(ringBuff);
        this.position += (long)n;
        return n;
    }

    @Override
    public final int write(ByteBuffer src) throws DataCorruptionException, DataSizeException {
        int m;
        if (src == null) {
            return 0;
        }
        MappedByteBuffer ringBuff = (MappedByteBuffer)this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        ringBuff.position((int)((this.offset + this.position) % (long)this.dataInputSize));
        int n = Math.min(src.remaining(), ringBuff.remaining());
        if (n > 0) {
            for (m = 0; m < n; ++m) {
                byte bi;
                byte bs = ringBuff.get();
                if (bs == (bi = src.get())) continue;
                throw new DataCorruptionException(m, bs, bi);
            }
            this.position += (long)n;
        } else {
            return n;
        }
        return m;
    }

    @Override
    public final long writeToSocketChannel(WritableByteChannel chanDst, long maxCount) throws IOException {
        MappedByteBuffer ringBuff = (MappedByteBuffer)this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        long doneCount = 0L;
        while (doneCount < maxCount) {
            ringBuff.position((int)((this.offset + this.position) % (long)this.dataInputSize));
            int n = (int)Math.min(maxCount - doneCount, (long)ringBuff.remaining());
            ringBuff.limit(ringBuff.position() + n);
            int m = chanDst.write(ringBuff);
            doneCount += (long)m;
            this.position += (long)m;
            if (m >= n) continue;
            break;
        }
        return doneCount;
    }

    @Override
    public final long writeToFileChannel(FileChannel chanDst, long maxCount) throws IOException {
        MappedByteBuffer ringBuff = (MappedByteBuffer)this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        int n = (int)((this.offset + this.position) % (long)this.dataInputSize);
        ringBuff.position(n);
        n = (int)Math.min(maxCount, (long)ringBuff.remaining());
        ringBuff.limit(ringBuff.position() + n);
        n = chanDst.write(ringBuff);
        this.position += (long)n;
        return n;
    }

    @Override
    public final <A> void writeToAsyncChannel(AsyncChannel dstChan, long dstPos, long maxCount, A attach, CompletionHandler<Integer, ? super A> handler) {
        MappedByteBuffer ringBuff = (MappedByteBuffer)this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        int n = (int)((this.offset + this.position) % (long)this.dataInputSize);
        ringBuff.position(n);
        n = (int)Math.min(maxCount, (long)ringBuff.remaining());
        ringBuff.limit(ringBuff.position() + n);
        dstChan.write(ringBuff, dstPos, attach, handler);
    }

    @Override
    public final void verify(ByteBuffer inBuff) throws DataCorruptionException {
        ByteBuffer ringBuff = this.dataInput.getLayer(this.layerNum).asReadOnlyBuffer();
        ringBuff.position((int)((this.offset + this.position) % (long)this.dataInputSize));
        this.verify(inBuff, ringBuff);
    }

    private void verify(ByteBuffer inBuff, ByteBuffer ringBuff) throws DataCorruptionException {
        int tailByteCount;
        int inputSize = inBuff.remaining();
        int sizeToVerify = Math.min(ringBuff.remaining(), inputSize);
        int wordCount = sizeToVerify >>> 3;
        if (wordCount > 0) {
            for (int k = 0; k < wordCount; ++k) {
                long wi;
                long ws = ringBuff.getLong();
                if (ws == (wi = inBuff.getLong())) continue;
                int wordPos = k << 3;
                for (int i = 0; i < 8; ++i) {
                    byte bs = (byte)ws;
                    ws >>= 8;
                    byte bi = (byte)wi;
                    wi >>= 8;
                    if (bs == bi) continue;
                    throw new DataCorruptionException(wordPos + i, bs, bi);
                }
            }
        }
        if ((tailByteCount = sizeToVerify & 7) > 0) {
            for (int m = 0; m < tailByteCount; ++m) {
                byte bi;
                byte bs = ringBuff.get();
                if (bs == (bi = inBuff.get())) continue;
                throw new DataCorruptionException(m, bs, bi);
            }
        }
        if (sizeToVerify < inputSize) {
            ringBuff.position(0);
            this.verify(inBuff, ringBuff);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataItemImpl)) {
            return false;
        }
        DataItemImpl other = (DataItemImpl)o;
        return super.equals(other) && this.offset == other.offset;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.offset;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.layerNum);
        out.writeLong(this.offset);
        out.writeLong(this.position);
        out.writeLong(this.size);
        byte[] buff = this.modifiedRangesMask.toByteArray();
        out.writeInt(buff.length);
        out.write(buff);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.layerNum = in.readInt();
        this.offset = in.readLong();
        this.position = in.readLong();
        this.size = in.readLong();
        int len = in.readInt();
        byte[] buff = new byte[len];
        in.readFully(buff);
        this.modifiedRangesMask.or(BitSet.valueOf(buff));
    }
}

