/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.io.AsyncChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;

public final class AsyncChannelWrapper
implements AsyncChannel {
    private final AsynchronousChannel channel;
    private final boolean isFileChannel;

    public AsyncChannelWrapper(AsynchronousChannel channel) {
        this.channel = channel;
        this.isFileChannel = channel instanceof AsynchronousFileChannel;
    }

    @Override
    public final boolean isFileChannel() {
        return this.isFileChannel;
    }

    @Override
    public final AsynchronousChannel wrapped() {
        return this.channel;
    }

    @Override
    public final <A> void read(ByteBuffer dst, long position, A attach, CompletionHandler<Integer, ? super A> handler) {
        if (this.isFileChannel) {
            ((AsynchronousFileChannel)this.channel).read(dst, position, attach, handler);
        } else {
            ((AsynchronousByteChannel)this.channel).read(dst, attach, handler);
        }
    }

    @Override
    public final <A> void write(ByteBuffer src, long position, A attach, CompletionHandler<Integer, ? super A> handler) {
        if (this.isFileChannel) {
            ((AsynchronousFileChannel)this.channel).write(src, position, attach, handler);
        } else {
            ((AsynchronousByteChannel)this.channel).write(src, attach, handler);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }
}

