/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class CsvItemOutput<I extends Item>
implements Output<I> {
    protected final ItemFactory<I> itemFactory;
    protected final BufferedWriter itemsDst;

    protected CsvItemOutput(OutputStream out, ItemFactory<I> itemFactory) throws IOException {
        this.itemsDst = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 0x100000);
        this.itemFactory = itemFactory;
    }

    @Override
    public boolean put(I item) {
        try {
            this.itemsDst.write(item.toString());
            this.itemsDst.newLine();
            return true;
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return false;
        }
    }

    @Override
    public int put(List<I> buffer, int from, int to) {
        int i;
        for (i = from; i < to && this.put((I)((Item)buffer.get(i))); ++i) {
        }
        return i - from;
    }

    @Override
    public final int put(List<I> items) {
        return this.put(items, 0, items.size());
    }

    @Override
    public void close() {
        try {
            this.itemsDst.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    public String toString() {
        return "csvItemOutput<" + this.itemsDst + ">";
    }
}

