/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.TransferConvertBuffer;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.EOFException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public final class DelayedTransferConvertBuffer<I extends Item, O extends Operation<I>>
implements TransferConvertBuffer<I, O> {
    private final List<O> ioResultsBuff;
    private final int ioResultsBuffLimit;
    private final List<O> markBuffer;
    private final long delayMicroseconds;
    private final Lock lock = new ReentrantLock();
    private volatile int markLimit = 0;
    private volatile int ioResultsBuffSize = 0;
    private volatile boolean poisonedFlag = false;

    public DelayedTransferConvertBuffer(int limit, long delay, TimeUnit timeUnit) {
        this.ioResultsBuff = new LinkedList<O>();
        this.ioResultsBuffLimit = limit;
        this.markBuffer = new LinkedList<O>();
        this.delayMicroseconds = timeUnit.toMicros(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(O ioResult) {
        if (this.poisonedFlag) {
            Exceptions.throwUnchecked(new EOFException(this.toString() + ": has been poisoned before"));
        }
        if (ioResult == null) {
            Loggers.MSG.debug("{}: poisoned", (Object)this);
            this.poisonedFlag = true;
            return true;
        }
        while (true) {
            if (this.lock.tryLock()) {
                try {
                    int ioResultsBuffSize = this.ioResultsBuffSize;
                    if (ioResultsBuffSize < this.ioResultsBuffLimit) {
                        this.ioResultsBuff.add(ioResult);
                        this.ioResultsBuffSize = ioResultsBuffSize + 1;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            LockSupport.parkNanos(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int put(List<O> ioResults, int from, int to) {
        if (this.poisonedFlag) {
            Exceptions.throwUnchecked(new EOFException(this + ": has been poisoned before"));
        }
        for (int i = from; i < to; ++i) {
            if (this.lock.tryLock()) {
                try {
                    int n = Math.min(to - i, this.ioResultsBuffLimit - this.ioResultsBuffSize);
                    if (n > 0) {
                        for (int j = 0; j < n; ++j) {
                            Operation ioResult = (Operation)ioResults.get(i + j);
                            if (ioResult == null) {
                                Loggers.MSG.debug("{}: poisoned", (Object)this);
                                this.poisonedFlag = true;
                                int n2 = to - i - j;
                                return n2;
                            }
                            this.ioResultsBuff.add(ioResult);
                        }
                        i += n;
                        continue;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            LockSupport.parkNanos(1L);
        }
        return to - from;
    }

    @Override
    public final int put(List<O> ioResults) {
        return this.put(ioResults, 0, ioResults.size());
    }

    @Override
    public final Input<O> getInput() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final I get() {
        I item = null;
        if (this.lock.tryLock()) {
            try {
                int ioResultsBuffSize = this.ioResultsBuffSize;
                if (ioResultsBuffSize == 0 && this.poisonedFlag) {
                    Exceptions.throwUnchecked(new EOFException());
                }
                ListIterator<O> ioResultsIter = this.ioResultsBuff.listIterator();
                while (ioResultsIter.hasNext()) {
                    Operation nextIoResult = (Operation)ioResultsIter.next();
                    int markLimit = this.markLimit;
                    if (this.delayMicroseconds > 0L) {
                        long nextFinishTime = nextIoResult.respTimeDone();
                        long currTime = Operation.START_OFFSET_MICROS + System.nanoTime() / 1000L;
                        if (currTime - nextFinishTime <= this.delayMicroseconds) continue;
                        item = nextIoResult.item();
                        if (markLimit > 0 && markLimit > this.markBuffer.size()) {
                            this.markBuffer.add(nextIoResult);
                        }
                        ioResultsIter.remove();
                        this.ioResultsBuffSize = ioResultsBuffSize + 1;
                    } else {
                        item = nextIoResult.item();
                        if (this.markBuffer.size() < markLimit) {
                            this.markBuffer.add(nextIoResult);
                        }
                        ioResultsIter.remove();
                        this.ioResultsBuffSize = ioResultsBuffSize + 1;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int get(List<I> buffer, int limit) {
        int n = 0;
        if (this.lock.tryLock()) {
            try {
                int ioResultsBuffSize = this.ioResultsBuffSize;
                if (ioResultsBuffSize == 0 && this.poisonedFlag) {
                    Exceptions.throwUnchecked(new EOFException());
                }
                ListIterator<O> ioResultsIter = this.ioResultsBuff.listIterator();
                int markLimit = this.markLimit;
                if (this.delayMicroseconds > 0L) {
                    while (ioResultsIter.hasNext() && n < limit) {
                        Operation nextIoResult = (Operation)ioResultsIter.next();
                        long nextFinishTime = nextIoResult.respTimeDone();
                        long currTime = Operation.START_OFFSET_MICROS + System.nanoTime() / 1000L;
                        if (currTime - nextFinishTime <= this.delayMicroseconds) continue;
                        buffer.add(nextIoResult.item());
                        if (markLimit > 0 && markLimit > this.markBuffer.size()) {
                            this.markBuffer.add(nextIoResult);
                        }
                        ioResultsIter.remove();
                        this.ioResultsBuffSize = ioResultsBuffSize + 1;
                        ++n;
                    }
                } else {
                    while (ioResultsIter.hasNext() && n < limit) {
                        Operation nextIoResult = (Operation)ioResultsIter.next();
                        buffer.add(nextIoResult.item());
                        if (markLimit > 0 && markLimit > this.markBuffer.size()) {
                            this.markBuffer.add(nextIoResult);
                        }
                        ioResultsIter.remove();
                        this.ioResultsBuffSize = ioResultsBuffSize + 1;
                        ++n;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long skip(long count) {
        long n;
        if (this.lock.tryLock()) {
            try {
                Iterator<O> ioResultsIter = this.ioResultsBuff.iterator();
                for (n = 0L; n < count && ioResultsIter.hasNext(); ++n) {
                    ioResultsIter.remove();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return n;
    }

    @Override
    public final void reset() {
        throw new AssertionError((Object)"Unable to reset this input");
    }

    @Override
    public final void close() {
        this.lock.lock();
        try {
            this.poisonedFlag = true;
            this.ioResultsBuff.clear();
            this.ioResultsBuffSize = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final String toString() {
        if (this.delayMicroseconds > 0L) {
            return "PreviousItemsWithDelay" + this.delayMicroseconds / 1000000L + "s";
        }
        return "PreviousItems";
    }
}

