/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.DataItemFactory;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.io.collection.BufferingInputBase;
import java.io.IOException;
import java.util.List;

public final class StorageItemInput<I extends Item>
extends BufferingInputBase<I> {
    private final StorageDriver<I, ? extends Operation<I>> storageDriver;
    private final ItemFactory<I> itemFactory;
    private final String path;
    private final String prefix;
    private final int idRadix;
    private boolean poisonedFlag = false;

    public StorageItemInput(StorageDriver<I, ? extends Operation<I>> storageDriver, int batchSize, ItemFactory<I> itemFactory, String path, String prefix, int idRadix) {
        super(batchSize);
        this.storageDriver = storageDriver;
        this.itemFactory = itemFactory;
        this.path = path;
        this.prefix = prefix;
        this.idRadix = idRadix;
    }

    @Override
    protected final int loadMoreItems(I lastItem) throws IOException {
        if (this.poisonedFlag) {
            return 0;
        }
        List<I> newItems = this.storageDriver.list(this.itemFactory, this.path, this.prefix, this.idRadix, lastItem, this.capacity);
        int n = newItems.size();
        for (int i = 0; i < n; ++i) {
            Item nextItem = (Item)newItems.get(i);
            if (null == nextItem) {
                this.poisonedFlag = true;
                return i;
            }
            this.items.add(nextItem);
        }
        return n;
    }

    @Override
    public final String toString() {
        return (this.itemFactory instanceof DataItemFactory ? "Data" : "") + "ItemsFromPath(" + this.path + ")";
    }

    @Override
    public final void reset() {
        super.reset();
        this.poisonedFlag = false;
    }
}

