/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.naming;

import com.emc.mongoose.base.item.naming.ItemNameInput;
import com.github.akurilov.commons.io.Input;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import java.util.List;

public final class ItemNameInputImpl
implements ItemNameInput {
    private final long initialId;
    private final Long2LongFunction idFunction;
    private volatile long lastId;
    private final Input<String> prefixInput;
    private final int radix;

    public ItemNameInputImpl(Long2LongFunction idFunction, long offset, Input<String> prefixInput, int radix) {
        this.lastId = this.initialId = offset;
        this.idFunction = idFunction;
        this.prefixInput = prefixInput;
        this.radix = radix;
    }

    @Override
    public final long lastId() {
        return this.lastId;
    }

    private void eval() {
        this.lastId = this.idFunction.applyAsLong(this.lastId);
    }

    private String convert() {
        return this.prefixInput.get() + Long.toString(this.lastId, this.radix);
    }

    @Override
    public final String get() {
        this.eval();
        return this.convert();
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        for (int i = 0; i < limit; ++i) {
            this.eval();
            buffer.add(this.convert());
        }
        return limit;
    }

    @Override
    public final long skip(long count) {
        for (long i = 0L; i < count; ++i) {
            this.idFunction.applyAsLong(this.lastId);
        }
        return count;
    }

    @Override
    public final void reset() {
        this.lastId = this.initialId;
    }

    @Override
    public final void close() throws Exception {
        this.prefixInput.close();
    }
}

