/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op.data;

import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.OperationImpl;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.storage.Credential;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class DataOperationImpl<T extends DataItem>
extends OperationImpl<T>
implements DataOperation<T> {
    protected final BitSet[] markedRangesMaskPair = new BitSet[]{new BitSet(64), new BitSet(64)};
    private int randomRangesCount = 0;
    private List<Range> fixedRanges = null;
    private List<T> srcItemsToConcat = null;
    protected long contentSize = 0L;
    protected volatile long countBytesDone = 0L;
    protected volatile long respDataTimeStart = 0L;
    private volatile DataItem currRange = null;
    private volatile int currRangeIdx = 0;

    public DataOperationImpl() {
    }

    public DataOperationImpl(int originIndex, OpType opType, T item, String srcPath, String dstPath, Credential credential, List<Range> fixedRanges, int randomRangesCount) throws IllegalArgumentException {
        super(originIndex, opType, item, srcPath, dstPath, credential);
        this.fixedRanges = fixedRanges;
        this.randomRangesCount = randomRangesCount;
        this.reset();
    }

    public DataOperationImpl(int originIndex, OpType opType, T item, String srcPath, String dstPath, Credential credential, List<Range> fixedRanges, int randomRangesCount, List<T> srcItemsToConcat) throws IllegalArgumentException {
        this(originIndex, opType, item, srcPath, dstPath, credential, fixedRanges, randomRangesCount);
        this.srcItemsToConcat = srcItemsToConcat;
    }

    protected DataOperationImpl(DataOperationImpl<T> other) {
        super(other);
        this.contentSize = other.contentSize;
        this.randomRangesCount = other.randomRangesCount;
        this.fixedRanges = other.fixedRanges;
        this.srcItemsToConcat = other.srcItemsToConcat;
        this.countBytesDone = other.countBytesDone;
        this.respDataTimeStart = other.respDataTimeStart;
    }

    @Override
    public DataOperationImpl<T> result() {
        this.buildItemPath((DataItem)this.item, this.dstPath == null ? this.srcPath : this.dstPath);
        return new DataOperationImpl<T>(this);
    }

    @Override
    public void reset() throws IllegalArgumentException {
        super.reset();
        this.countBytesDone = 0L;
        this.respDataTimeStart = 0L;
        this.currRange = null;
        this.currRangeIdx = 0;
        this.markedRangesMaskPair[0].clear();
        this.markedRangesMaskPair[1].clear();
        try {
            switch (this.opType) {
                case CREATE: {
                    this.contentSize = ((DataItem)this.item).size();
                    break;
                }
                case READ: {
                    if (this.fixedRanges == null || this.fixedRanges.isEmpty()) {
                        if (this.randomRangesCount > 0) {
                            this.markRandomRanges(this.randomRangesCount);
                            this.contentSize = this.markedRangesSize();
                            break;
                        }
                        this.contentSize = ((DataItem)this.item).size();
                        break;
                    }
                    this.contentSize = this.markedRangesSize();
                    if (this.contentSize > ((DataItem)this.item).size()) {
                        throw new IllegalArgumentException("Fixed ranges size (" + SizeInBytes.formatFixedSize(this.contentSize) + ") is more than data item size (" + SizeInBytes.formatFixedSize(((DataItem)this.item).size()));
                    }
                    break;
                }
                case UPDATE: {
                    if (this.fixedRanges == null || this.fixedRanges.isEmpty()) {
                        if (this.randomRangesCount > 0) {
                            this.markRandomRanges(this.randomRangesCount);
                        } else {
                            this.fixedRanges = new ArrayList<Range>(1);
                            this.fixedRanges.add(new Range(0L, ((DataItem)this.item).size() - 1L, -1L));
                        }
                    }
                    this.contentSize = this.markedRangesSize();
                    break;
                }
                default: {
                    this.contentSize = 0L;
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final void markRandomRanges(int count) {
        try {
            int countRangesTotal = DataItem.rangeCount(((DataItem)this.item).size());
            if (count < 1 || count > countRangesTotal) {
                throw new AssertionError((Object)("Range count should be more than 0 and less than max " + countRangesTotal + " for the item size"));
            }
            for (int i = 0; i < count; ++i) {
                this.markRandomRangesActually(countRangesTotal);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void markRandomRangesActually(int countRangesTotal) {
        int startCellPos = (int)(System.nanoTime() % (long)countRangesTotal);
        if (countRangesTotal > ((DataItem)this.item).updatedRangesCount() + this.markedRangesMaskPair[0].cardinality()) {
            for (int i = 0; i < countRangesTotal; ++i) {
                int nextCellPos = (startCellPos + i) % countRangesTotal;
                if (((DataItem)this.item).isRangeUpdated(nextCellPos) || this.markedRangesMaskPair[0].get(nextCellPos)) continue;
                this.markedRangesMaskPair[0].set(nextCellPos);
                break;
            }
        } else {
            for (int i = 0; i < countRangesTotal; ++i) {
                int nextCellPos = (startCellPos + i) % countRangesTotal;
                if (this.markedRangesMaskPair[0].get(nextCellPos) || this.markedRangesMaskPair[1].get(nextCellPos)) continue;
                this.markedRangesMaskPair[1].set(nextCellPos);
                break;
            }
        }
    }

    @Override
    public final boolean hasMarkedRanges() {
        return !this.markedRangesMaskPair[0].isEmpty() || !this.markedRangesMaskPair[1].isEmpty();
    }

    @Override
    public final BitSet[] markedRangesMaskPair() {
        return this.markedRangesMaskPair;
    }

    @Override
    public final long markedRangesSize() {
        long sumSize = 0L;
        if (this.fixedRanges == null || this.fixedRanges.isEmpty()) {
            try {
                for (int i = 0; i < DataItem.rangeCount(((DataItem)this.item).size()); ++i) {
                    if (!this.markedRangesMaskPair[0].get(i) && !this.markedRangesMaskPair[1].get(i)) continue;
                    sumSize += ((DataItem)this.item).rangeSize(i);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            for (Range nextRange : this.fixedRanges) {
                long nextBeg = nextRange.getBeg();
                long nextEnd = nextRange.getEnd();
                long nextSize = nextRange.getSize();
                if (nextSize == -1L) {
                    if (nextBeg == -1L) {
                        sumSize += nextEnd;
                        continue;
                    }
                    if (nextEnd == -1L) {
                        try {
                            sumSize += ((DataItem)this.item).size() - nextBeg;
                            continue;
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    sumSize += nextEnd - nextBeg + 1L;
                    continue;
                }
                sumSize += nextSize;
            }
        }
        return sumSize;
    }

    @Override
    public final List<Range> fixedRanges() {
        return this.fixedRanges;
    }

    @Override
    public final int randomRangesCount() {
        return this.randomRangesCount;
    }

    @Override
    public final List<T> srcItemsToConcat() {
        return this.srcItemsToConcat;
    }

    @Override
    public final int currRangeIdx() {
        return this.currRangeIdx;
    }

    @Override
    public final void currRangeIdx(int currRangeIdx) {
        this.currRange = null;
        this.currRangeIdx = currRangeIdx;
    }

    @Override
    public final DataItem currRange() {
        DataItem currRange = this.currRange;
        int currRangeIdx = this.currRangeIdx;
        try {
            if (currRange == null && currRangeIdx < DataItem.rangeCount(((DataItem)this.item).size())) {
                long currRangeSize = ((DataItem)this.item).rangeSize(currRangeIdx);
                long currRangeOffset = DataItem.rangeOffset(currRangeIdx);
                int layerIdx = ((DataItem)this.item).layer();
                this.currRange = currRange = ((DataItem)this.item).slice(currRangeOffset, currRangeSize);
                if (((DataItem)this.item).isRangeUpdated(currRangeIdx)) {
                    currRange.layer(layerIdx + 1);
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return currRange;
    }

    @Override
    public final DataItem currRangeUpdate() {
        DataItem currRange = this.currRange;
        int currRangeIdx = this.currRangeIdx;
        if (currRange == null) {
            int layerIdx = ((DataItem)this.item).layer();
            if (this.markedRangesMaskPair[0].get(currRangeIdx)) {
                long currRangeSize = ((DataItem)this.item).rangeSize(currRangeIdx);
                long currRangeOffset = DataItem.rangeOffset(currRangeIdx);
                currRange = ((DataItem)this.item).slice(currRangeOffset, currRangeSize);
                currRange.layer(layerIdx + 1);
            } else if (this.markedRangesMaskPair[1].get(currRangeIdx)) {
                long currRangeSize = ((DataItem)this.item).rangeSize(currRangeIdx);
                long currRangeOffset = DataItem.rangeOffset(currRangeIdx);
                this.currRange = currRange = ((DataItem)this.item).slice(currRangeOffset, currRangeSize);
                currRange.layer(layerIdx + 2);
            } else {
                currRange = null;
            }
        }
        return currRange;
    }

    @Override
    public final long countBytesDone() {
        return this.countBytesDone;
    }

    @Override
    public final void countBytesDone(long n) {
        this.countBytesDone = n;
    }

    @Override
    public final long respDataTimeStart() {
        return this.respDataTimeStart;
    }

    @Override
    public final void startDataResponse() {
        this.respDataTimeStart = Operation.START_OFFSET_MICROS + System.nanoTime() / 1000L;
        if (this.reqTimeDone == 0L) {
            throw new IllegalStateException("Response data is started (" + this.respDataTimeStart + ") before the request is finished (" + this.reqTimeDone + ")");
        }
    }

    @Override
    public final long dataLatency() {
        return this.respDataTimeStart - this.reqTimeDone;
    }
}

