/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op.data;

import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.op.OperationsBuilderImpl;
import com.emc.mongoose.base.item.op.composite.data.CompositeDataOperationImpl;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.item.op.data.DataOperationImpl;
import com.emc.mongoose.base.item.op.data.DataOperationsBuilder;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.math.Random;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataOperationsBuilderImpl<I extends DataItem, O extends DataOperation<I>>
extends OperationsBuilderImpl<I, O>
implements DataOperationsBuilder<I, O> {
    private final Random rnd = new Random();
    protected volatile List<I> srcItemsForConcat = null;
    protected volatile int srcItemsCount = 0;
    protected volatile int srcItemsCountMin = 0;
    protected volatile int srcItemsCountMax = 0;
    protected volatile List<Range> fixedRanges = null;
    protected volatile int randomRangesCount = 0;
    protected volatile long sizeThreshold = 0L;

    public DataOperationsBuilderImpl(int originIndex) {
        super(originIndex);
    }

    @Override
    public DataOperationsBuilderImpl<I, O> fixedRanges(List<Range> fixedRanges) {
        this.fixedRanges = fixedRanges;
        return this;
    }

    @Override
    public DataOperationsBuilderImpl<I, O> randomRangesCount(int count) {
        this.randomRangesCount = count;
        return this;
    }

    @Override
    public DataOperationsBuilderImpl<I, O> sizeThreshold(long sizeThreshold) {
        this.sizeThreshold = sizeThreshold > 0L ? sizeThreshold : Long.MAX_VALUE;
        return this;
    }

    @Override
    public DataOperationsBuilderImpl<I, O> srcItemsCount(int min, int max) {
        this.srcItemsCountMin = min;
        this.srcItemsCountMax = max;
        return this;
    }

    @Override
    public DataOperationsBuilderImpl<I, O> srcItemsForConcat(List<I> srcItemsForConcat) {
        this.srcItemsForConcat = srcItemsForConcat;
        if (this.srcItemsForConcat != null) {
            this.srcItemsCount = srcItemsForConcat.size();
        }
        return this;
    }

    @Override
    public List<Range> fixedRanges() {
        return this.fixedRanges;
    }

    @Override
    public int randomRangesCount() {
        return this.randomRangesCount;
    }

    @Override
    public long sizeThreshold() {
        return this.sizeThreshold;
    }

    @Override
    public O buildOp(I dataItem) throws IOException, IllegalArgumentException {
        String outputPath = this.getNextOutputPath();
        if (dataItem.size() > this.sizeThreshold) {
            if (this.randomRangesCount > 0 || this.fixedRanges != null && this.fixedRanges.size() > 0) {
                throw new IllegalArgumentException("Not supported - both byte ranges configured and size threshold");
            }
            return (O)new CompositeDataOperationImpl<I>(this.originIndex, this.opType, dataItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount, this.sizeThreshold);
        }
        if (this.srcItemsCount > 0) {
            return (O)new DataOperationImpl<I>(this.originIndex, this.opType, dataItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount, this.getNextSrcItemsForConcat());
        }
        if (this.randomRangesCount > DataItem.rangeCount(dataItem.size())) {
            throw new IllegalArgumentException("Configured random ranges count (" + this.randomRangesCount + ") is more than allowed for the data item w/ size " + SizeInBytes.formatFixedSize(dataItem.size()));
        }
        return (O)new DataOperationImpl<I>(this.originIndex, this.opType, dataItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount);
    }

    @Override
    public void buildOps(List<I> items, List<O> buff) throws IOException, IllegalArgumentException {
        for (DataItem nextItem : items) {
            String outputPath = this.getNextOutputPath();
            if (nextItem.size() > this.sizeThreshold) {
                if (this.randomRangesCount > 0 || this.fixedRanges != null && this.fixedRanges.size() > 0) {
                    throw new IllegalArgumentException("Not supported - both byte ranges configured and size threshold");
                }
                buff.add(new CompositeDataOperationImpl<DataItem>(this.originIndex, this.opType, nextItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount, this.sizeThreshold));
                continue;
            }
            if (this.srcItemsCount > 0) {
                buff.add(new DataOperationImpl<DataItem>(this.originIndex, this.opType, nextItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount, this.getNextSrcItemsForConcat()));
                continue;
            }
            if (this.randomRangesCount > DataItem.rangeCount(nextItem.size())) {
                throw new IllegalArgumentException("Configured random ranges count (" + this.randomRangesCount + ") is more than allowed for the data item w/ size " + SizeInBytes.formatFixedSize(nextItem.size()));
            }
            buff.add(new DataOperationImpl<DataItem>(this.originIndex, this.opType, nextItem, this.inputPath, outputPath, this.getNextCredential(outputPath), this.fixedRanges, this.randomRangesCount));
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.srcItemsForConcat != null) {
            this.srcItemsForConcat.clear();
            this.srcItemsForConcat = null;
        }
        if (this.fixedRanges != null) {
            this.fixedRanges.clear();
            this.fixedRanges = null;
        }
    }

    protected List<I> getNextSrcItemsForConcat() {
        int n = this.srcItemsCountMin < this.srcItemsCountMax ? this.srcItemsCountMin + this.rnd.nextInt(this.srcItemsCountMax - this.srcItemsCountMin + 1) : this.srcItemsCountMin;
        ArrayList<DataItem> selectedItems = new ArrayList<DataItem>(n);
        for (int i = 0; i < n; ++i) {
            selectedItems.add((DataItem)this.srcItemsForConcat.get(this.rnd.nextInt(this.srcItemsCount)));
        }
        return selectedItems;
    }
}

