/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.generator;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.ServiceTaskExecutor;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.OperationsBuilder;
import com.emc.mongoose.base.load.generator.LoadGenerator;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.collection.CircularArrayBuffer;
import com.github.akurilov.commons.collection.CircularBuffer;
import com.github.akurilov.commons.concurrent.throttle.IndexThrottle;
import com.github.akurilov.commons.concurrent.throttle.Throttle;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.fiber4j.FiberBase;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class LoadGeneratorImpl<I extends Item, O extends Operation<I>>
extends FiberBase
implements LoadGenerator<I, O> {
    private static final String CLS_NAME = LoadGeneratorImpl.class.getSimpleName();
    private volatile boolean recycleQueueFullState = false;
    private volatile boolean itemInputFinishFlag = false;
    private volatile boolean opInputFinishFlag = false;
    private volatile boolean outputFinishFlag = false;
    private final Input<I> itemInput;
    private final OperationsBuilder<I, O> opsBuilder;
    private final int originIndex;
    private final Object[] throttles;
    private final Output<O> opOutput;
    private final Lock inputLock = new ReentrantLock();
    private final int batchSize;
    private final long countLimit;
    private final BlockingQueue<O> recycleQueue;
    private final boolean recycleFlag;
    private final boolean shuffleFlag;
    private final Random rnd;
    private final String name;
    private final ThreadLocal<CircularBuffer<O>> threadLocalOpBuff;
    private final LongAdder builtTasksCounter = new LongAdder();
    private final LongAdder recycledOpCounter = new LongAdder();
    private final LongAdder outputOpCounter = new LongAdder();

    public LoadGeneratorImpl(Input<I> itemInput, OperationsBuilder<I, O> opsBuilder, List<Object> throttles, Output<O> opOutput, int batchSize, long countLimit, int recycleQueueSize, boolean recycleFlag, boolean shuffleFlag) {
        super(ServiceTaskExecutor.INSTANCE);
        this.itemInput = itemInput;
        this.opsBuilder = opsBuilder;
        this.originIndex = opsBuilder.originIndex();
        this.throttles = throttles.toArray(new Object[0]);
        this.opOutput = opOutput;
        this.batchSize = batchSize;
        this.countLimit = countLimit > 0L ? countLimit : Long.MAX_VALUE;
        this.recycleQueue = new ArrayBlockingQueue<O>(recycleQueueSize, true);
        this.recycleFlag = recycleFlag;
        this.shuffleFlag = shuffleFlag;
        this.rnd = shuffleFlag ? new Random() : null;
        String ioStr = opsBuilder.opType().toString();
        this.name = Character.toUpperCase(ioStr.charAt(0)) + ioStr.substring(1).toLowerCase() + (countLimit > 0L && countLimit < Long.MAX_VALUE ? Long.toString(countLimit) : "") + itemInput.toString();
        this.threadLocalOpBuff = ThreadLocal.withInitial(() -> new CircularArrayBuffer(batchSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invokeTimed(long startTimeNanos) {
        block44: {
            ThreadContext.put("class_name", CLS_NAME);
            CircularBuffer<O> opBuff = this.threadLocalOpBuff.get();
            int pendingOpCount = opBuff.size();
            int n = this.batchSize - pendingOpCount;
            try {
                if (n > 0) {
                    if (this.itemInputFinishFlag) {
                        if (!this.recycleFlag) {
                            this.opInputFinishFlag = true;
                        } else if ((n = this.recycleQueue.drainTo(opBuff, n)) > 0) {
                            pendingOpCount += n;
                            this.recycledOpCounter.add(n);
                        }
                    } else if (this.inputLock.tryLock()) {
                        try {
                            long remainingOpCount = this.countLimit - this.generatedOpCount();
                            if (remainingOpCount > 0L) {
                                List<I> items = LoadGeneratorImpl.getItems(this.itemInput, n = (int)Math.min(remainingOpCount, (long)n));
                                if (items == null) {
                                    this.itemInputFinishFlag = true;
                                    Loggers.MSG.debug("End of items input \"{}\", generated op count: {}", (Object)this.itemInput.toString(), (Object)this.generatedOpCount());
                                } else {
                                    n = items.size();
                                    if (n > 0) {
                                        pendingOpCount = (int)((long)pendingOpCount + this.buildOps(items, opBuff, n));
                                    }
                                }
                            }
                        }
                        finally {
                            this.inputLock.unlock();
                        }
                    }
                }
                if (this.outputOpCounter.sum() < this.countLimit) {
                    if (pendingOpCount <= 0) break block44;
                    n = pendingOpCount;
                    for (int i = 0; i < this.throttles.length; ++i) {
                        Object throttle = this.throttles[i];
                        if (throttle instanceof Throttle) {
                            n = ((Throttle)throttle).tryAcquire(n);
                            continue;
                        }
                        if (throttle instanceof IndexThrottle) {
                            n = ((IndexThrottle)throttle).tryAcquire(this.originIndex, n);
                            continue;
                        }
                        throw new AssertionError((Object)("Unexpected throttle type: " + throttle.getClass()));
                    }
                    if (n <= 0) break block44;
                    if (n == 1) {
                        try {
                            Operation op = (Operation)opBuff.get(0);
                            if (!this.opOutput.put(op)) break block44;
                            this.outputOpCounter.increment();
                            if (pendingOpCount == 1) {
                                opBuff.clear();
                                break block44;
                            }
                            opBuff.remove(0);
                        }
                        catch (Exception e) {
                            Exceptions.throwUncheckedIfInterrupted(e);
                            if (e instanceof EOFException) {
                                Loggers.MSG.debug("{}: finish due to output's EOF, {}", (Object)this.name, (Object)e);
                                this.outputFinishFlag = true;
                                break block44;
                            }
                            LogUtil.exception(Level.ERROR, e, "{}: operation output failure", this.name);
                        }
                        break block44;
                    }
                    try {
                        n = this.opOutput.put(opBuff, 0, n);
                        this.outputOpCounter.add(n);
                        if (n < pendingOpCount) {
                            opBuff.removeFirst(n);
                            break block44;
                        }
                        opBuff.clear();
                    }
                    catch (Exception e) {
                        Exceptions.throwUncheckedIfInterrupted(e);
                        if (e instanceof EOFException) {
                            Loggers.MSG.debug("{}: finish due to output's EOF, {}", (Object)this.name, (Object)e);
                            this.outputFinishFlag = true;
                            break block44;
                        }
                        LogUtil.trace(Loggers.ERR, Level.ERROR, e, "Unexpected failure", new Object[0]);
                    }
                    break block44;
                }
                this.outputFinishFlag = true;
            }
            catch (EOFException e) {
            }
            catch (Throwable t) {
                Exceptions.throwUncheckedIfInterrupted(t);
                LogUtil.trace(Loggers.ERR, Level.ERROR, t, "{}: unexpected failure", this.name);
            }
            finally {
                if (this.isFinished()) {
                    try {
                        this.stop();
                    }
                    catch (IllegalStateException e) {}
                }
            }
        }
    }

    private static <I extends Item> List<I> getItems(Input<I> itemInput, int n) {
        ArrayList items;
        block2: {
            items = new ArrayList(n);
            try {
                itemInput.get(items, n);
            }
            catch (Exception e) {
                Exceptions.throwUncheckedIfInterrupted(e);
                if (!(e instanceof EOFException)) break block2;
                return null;
            }
        }
        return items;
    }

    private long buildOps(List<I> items, CircularBuffer<O> opBuff, int n) throws IOException {
        if (this.shuffleFlag) {
            Collections.shuffle(items, this.rnd);
        }
        try {
            this.opsBuilder.buildOps(items, opBuff);
            this.builtTasksCounter.add(n);
            return n;
        }
        catch (IllegalArgumentException e) {
            LogUtil.exception(Level.ERROR, e, "Failed to generate the load operation", new Object[0]);
            return 0L;
        }
    }

    @Override
    public final boolean isItemInputFinished() {
        return this.itemInputFinishFlag;
    }

    @Override
    public final long generatedOpCount() {
        return this.builtTasksCounter.sum() + this.recycledOpCounter.sum();
    }

    @Override
    public final void recycle(O op) {
        if (!this.recycleQueue.offer(op) && !this.recycleQueueFullState && 0 == this.recycleQueue.remainingCapacity()) {
            this.recycleQueueFullState = true;
            Loggers.ERR.error("{}: cannot recycle the operation, queue is full", (Object)this.name);
        }
    }

    @Override
    public final boolean isNothingToRecycle() {
        return this.recycleQueue.isEmpty();
    }

    private boolean isFinished() {
        return this.outputFinishFlag || this.itemInputFinishFlag && this.opInputFinishFlag && this.generatedOpCount() == this.outputOpCounter.sum();
    }

    @Override
    protected final void doStop() throws IllegalStateException {
        super.doStop();
        Loggers.MSG.debug("{}: generated {}, recycled {}, output {} operations", (Object)this.toString(), (Object)this.builtTasksCounter.sum(), (Object)this.recycledOpCounter.sum(), (Object)this.outputOpCounter.sum());
    }

    @Override
    protected final void doClose() {
        this.recycleQueue.clear();
        if (this.itemInput != null) {
            try {
                this.inputLock.tryLock(10000000000L, TimeUnit.NANOSECONDS);
                this.itemInput.close();
            }
            catch (InterruptedException e) {
                com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
            }
            catch (Exception e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to close the item input", this.toString());
            }
        }
        this.opsBuilder.close();
    }

    public final String toString() {
        return this.name;
    }
}

