/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.DaemonBase;
import com.emc.mongoose.base.concurrent.ServiceTaskExecutor;
import com.emc.mongoose.base.config.ConfigFormat;
import com.emc.mongoose.base.config.ConfigUtil;
import com.emc.mongoose.base.config.TimeUtil;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class LoadStepBase
extends DaemonBase
implements LoadStep,
Runnable {
    protected final Config config;
    protected final List<Extension> extensions;
    protected final List<Config> ctxConfigs;
    protected final MetricsManager metricsMgr;
    protected final List<MetricsContext<? extends AllMetricsSnapshot>> metricsContexts = new ArrayList<MetricsContext<? extends AllMetricsSnapshot>>();
    private volatile long timeLimitSec = Long.MAX_VALUE;
    private volatile long startTimeSec = -1L;

    protected LoadStepBase(Config config, List<Extension> extensions, List<Config> ctxConfigs, MetricsManager metricsMgr) {
        this.config = new BasicConfig(config);
        this.extensions = extensions;
        this.ctxConfigs = ctxConfigs;
        this.metricsMgr = metricsMgr;
        Loggers.CONFIG.info(ConfigUtil.toString(config, ConfigFormat.YAML));
    }

    @Override
    public final String loadStepId() {
        return this.config.stringVal("load-step-id");
    }

    @Override
    public final long runId() {
        return this.config.longVal("run-id");
    }

    @Override
    public final List<? extends AllMetricsSnapshot> metricsSnapshots() {
        int count = this.metricsContexts.size();
        ArrayList<AllMetricsSnapshot> metricsSnapshots = new ArrayList<AllMetricsSnapshot>(count);
        for (int i = 0; i < count; ++i) {
            AllMetricsSnapshot snapshot;
            MetricsContext<? extends AllMetricsSnapshot> ctx = this.metricsContexts.get(i);
            if (null == ctx || null == (snapshot = ctx.lastSnapshot())) continue;
            metricsSnapshots.add(snapshot);
        }
        return metricsSnapshots;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void doStart() throws IllegalStateException {
        this.init();
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
            this.doStartWrapped();
            int svcThreadCount = this.config.intVal("load-service-threads");
            ServiceTaskExecutor.INSTANCE.setThreadCount(svcThreadCount);
            Object loadStepLimitTimeRaw = this.config.val("load-step-limit-time");
            long t = loadStepLimitTimeRaw instanceof String ? TimeUtil.getTimeInSeconds((String)loadStepLimitTimeRaw) : TypeUtil.typeConvert(loadStepLimitTimeRaw, Long.TYPE);
            if (t > 0L) {
                this.timeLimitSec = t;
            }
            this.startTimeSec = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        }
        catch (Throwable cause) {
            Exceptions.throwUncheckedIfInterrupted(cause);
            LogUtil.exception(Level.WARN, cause, "{} step failed to start", this.loadStepId());
        }
        this.metricsContexts.stream().peek(MetricsContext::start).forEach(this.metricsMgr::register);
    }

    protected abstract void doStartWrapped();

    protected abstract void init() throws IllegalStateException;

    protected abstract void initMetrics(int var1, OpType var2, int var3, Config var4, SizeInBytes var5, boolean var6);

    @Override
    protected void doStop() {
        this.metricsContexts.forEach(this.metricsMgr::unregister);
        long t = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - this.startTimeSec;
        if (t < 0L) {
            Loggers.ERR.warn("Stopped earlier than started, won't account the elapsed time");
        } else if (t > this.timeLimitSec) {
            Loggers.MSG.warn("The elapsed time ({}[s]) is more than the limit ({}[s]), further resuming is not available", (Object)t, (Object)this.timeLimitSec);
            this.timeLimitSec = 0L;
        } else {
            this.timeLimitSec -= t;
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.metricsContexts.forEach(MetricsContext::close);
    }

    protected int avgPeriod(Config metricsConfig) {
        Object metricsAvgPeriodRaw = metricsConfig.val("average-period");
        if (metricsAvgPeriodRaw instanceof String) {
            return (int)TimeUtil.getTimeInSeconds((String)metricsAvgPeriodRaw);
        }
        return TypeUtil.typeConvert(metricsAvgPeriodRaw, Integer.TYPE);
    }
}

