/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.client.LoadStepClient;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.github.akurilov.confuse.Config;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface LoadStepFactory<T extends LoadStep, U extends LoadStepClient>
extends Extension {
    public T createLocal(Config var1, List<Extension> var2, List<Config> var3, MetricsManager var4);

    public U createClient(Config var1, List<Extension> var2, MetricsManager var3);

    public static <T extends LoadStep> T createLocalLoadStep(Config baseConfig, List<Extension> extensions, List<Config> contextConfigs, MetricsManager metricsManager, String stepType) {
        List loadStepFactories = extensions.stream().filter(ext -> ext instanceof LoadStepFactory).map(ext -> (LoadStepFactory)ext).collect(Collectors.toList());
        LoadStepFactory selectedFactory = loadStepFactories.stream().filter(f -> stepType.equals(f.id())).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the load step implementation for type \"" + stepType + "\", available types: " + Arrays.toString(loadStepFactories.stream().map(Extension::id).toArray())));
        return selectedFactory.createLocal(baseConfig, extensions, contextConfigs, metricsManager);
    }
}

