/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.concurrent.ServiceTaskExecutor;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.fiber4j.ExclusiveFiberBase;
import java.rmi.RemoteException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public class AwaitStepSliceTask
extends ExclusiveFiberBase {
    private final LoadStep stepSlice;
    private final String loadStepId;
    private final CountDownLatch awaitCountDown;

    public AwaitStepSliceTask(LoadStep stepSlice, CountDownLatch awaitCountDown) {
        super(ServiceTaskExecutor.INSTANCE);
        this.stepSlice = stepSlice;
        try {
            this.loadStepId = stepSlice.loadStepId();
        }
        catch (RemoteException e) {
            LogUtil.exception(Level.ERROR, e, "Failed to connect the load step slice", new Object[0]);
            throw new IllegalStateException(e);
        }
        this.awaitCountDown = awaitCountDown;
    }

    @Override
    protected final void invokeTimedExclusively(long startTimeNanos) {
        Loggers.MSG.trace("{}: await for the step slice \"{}\" started", (Object)this.loadStepId, (Object)this.stepSlice);
        try {
            if (this.stepSlice.await(10000000L, TimeUnit.NANOSECONDS)) {
                this.awaitCountDown.countDown();
                this.stop();
            }
        }
        catch (RemoteException e) {
            LogUtil.exception(Level.WARN, e, "Failed to invoke the remote await method on the step slice \"{}\"", this.stepSlice);
        }
        catch (InterruptedException e) {
            Exceptions.throwUnchecked(e);
        }
        catch (IllegalStateException e) {
            LogUtil.exception(Level.WARN, e, "{}: failure in the await method", this.loadStepId);
        }
    }
}

