/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.config.el.Language;
import com.emc.mongoose.base.item.naming.ItemNameInput;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.io.el.ExpressionInput;
import com.github.akurilov.commons.math.MathUtil;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.Level;

public interface ConfigSliceUtil {
    public static Config initSlice(Config config) {
        BasicConfig configSlice = new BasicConfig(config);
        configSlice.val("load-step-node-addrs", Collections.EMPTY_LIST);
        return configSlice;
    }

    public static void sliceLongValue(long configVal, List<Config> configSlices, String configPath) {
        int sliceCount = configSlices.size();
        long configValPerSlice = (long)Math.ceil((double)configVal / (double)sliceCount);
        long remainingVal = configVal;
        for (int i = 0; i < sliceCount; ++i) {
            Config configSlice = configSlices.get(i);
            if (remainingVal > configValPerSlice) {
                Loggers.MSG.debug("Config slice #{}: {} = {}", (Object)i, (Object)configPath, (Object)configValPerSlice);
                configSlice.val(configPath, configValPerSlice);
                remainingVal -= configValPerSlice;
                continue;
            }
            Loggers.MSG.debug("Config slice #{}: {} = {}", (Object)i, (Object)configPath, (Object)remainingVal);
            configSlice.val(configPath, remainingVal);
            remainingVal = 0L;
        }
    }

    public static void sliceDoubleValue(double configVal, List<Config> configSlices, String configPath) {
        int sliceCount = configSlices.size();
        double configValPerSlice = configVal / (double)sliceCount;
        for (int i = 0; i < sliceCount; ++i) {
            Config configSlice = configSlices.get(i);
            Loggers.MSG.debug("Config slice #{}: {} = {}", (Object)i, (Object)configPath, (Object)configValPerSlice);
            configSlice.val(configPath, configValPerSlice);
        }
    }

    public static void sliceStorageNodeAddrs(List<Config> configSlices, List<String> storageNodeAddrs) {
        int sliceCount = configSlices.size();
        int storageNodeCount = storageNodeAddrs.size();
        if (storageNodeCount > 1) {
            int gcd = MathUtil.gcd(sliceCount, storageNodeCount);
            int sliceCountPerGcd = sliceCount / gcd;
            int storageNodeCountPerGcd = storageNodeCount / gcd;
            for (int i = 0; i < gcd; ++i) {
                int j;
                ArrayList<String> storageNodeAddrsSlice = new ArrayList<String>(storageNodeCountPerGcd);
                for (j = storageNodeCountPerGcd * i; j < storageNodeCountPerGcd * (i + 1); ++j) {
                    storageNodeAddrsSlice.add(storageNodeAddrs.get(j));
                }
                for (j = i * sliceCountPerGcd; j < (i + 1) * sliceCountPerGcd; ++j) {
                    Loggers.MSG.info("Load step slice #{} ({}) storage nodes: {}", (Object)j, (Object)(j == 0 ? "local" : "remote"), (Object)Arrays.toString(storageNodeAddrsSlice.toArray()));
                    configSlices.get(i).val("storage-net-node-addrs", storageNodeAddrsSlice);
                }
            }
        }
    }

    public static void sliceItemNaming(List<Config> configSlices) {
        block13: {
            try {
                long srcNamingSeed;
                Config namingConfig = configSlices.get(0).configVal("item-naming");
                ItemNameInput.ItemNamingType namingType = ItemNameInput.ItemNamingType.valueOf(namingConfig.stringVal("type").toUpperCase());
                if (!ItemNameInput.ItemNamingType.SERIAL.equals((Object)namingType)) break block13;
                int sliceCount = configSlices.size();
                Object srcNamingSeedRaw = namingConfig.val("seed");
                try {
                    srcNamingSeed = TypeUtil.typeConvert(srcNamingSeedRaw, Long.TYPE);
                }
                catch (ClassCastException | NumberFormatException e) {
                    if (srcNamingSeedRaw instanceof String) {
                        try (Object in = Language.withLanguage(ExpressionInput.builder()).expression((String)srcNamingSeedRaw).build();){
                            srcNamingSeed = (Long)in.get();
                        }
                    }
                    throw new Exception("Item naming seed value (" + srcNamingSeedRaw + ") should be an integer either expression");
                }
                int srcNamingStep = namingConfig.intVal("step");
                for (int i = 0; i < sliceCount; ++i) {
                    Config configSlice = configSlices.get(i);
                    Loggers.MSG.debug("Item naming slicing: slice #{}, seed: {}, step: {}", (Object)i, (Object)(srcNamingSeed + (long)(i * srcNamingStep)), (Object)(srcNamingStep * sliceCount));
                    configSlice.val("item-naming-seed", srcNamingSeed + (long)(i * srcNamingStep));
                    configSlice.val("item-naming-step", srcNamingStep * sliceCount);
                }
            }
            catch (NoSuchElementException namingConfig) {
            }
            catch (Exception e) {
                LogUtil.exception(Level.ERROR, e, "Item naming slicing failure", new Object[0]);
            }
        }
    }
}

