/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.AliasingUtil;
import com.emc.mongoose.base.config.ConfigUtil;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.io.ItemInputFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.LoadStepBase;
import com.emc.mongoose.base.load.step.LoadStepFactory;
import com.emc.mongoose.base.load.step.client.ConfigSliceUtil;
import com.emc.mongoose.base.load.step.client.FileManagerClient;
import com.emc.mongoose.base.load.step.client.ItemDataInputFileSlicer;
import com.emc.mongoose.base.load.step.client.ItemInputFileSlicer;
import com.emc.mongoose.base.load.step.client.ItemOutputFileAggregator;
import com.emc.mongoose.base.load.step.client.LoadStepClient;
import com.emc.mongoose.base.load.step.client.LoadStepSliceUtil;
import com.emc.mongoose.base.load.step.client.OpTraceLogFileAggregator;
import com.emc.mongoose.base.load.step.client.TempInputTextFileSlicer;
import com.emc.mongoose.base.load.step.client.metrics.MetricsAggregator;
import com.emc.mongoose.base.load.step.client.metrics.MetricsAggregatorImpl;
import com.emc.mongoose.base.load.step.file.FileManager;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.DistributedContextBuilder;
import com.emc.mongoose.base.metrics.context.DistributedMetricsContext;
import com.emc.mongoose.base.metrics.context.DistributedMetricsContextImpl;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.net.NetUtil;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class LoadStepClientBase
extends LoadStepBase
implements LoadStepClient {
    private final List<LoadStep> stepSlices = new ArrayList<LoadStep>();
    private final List<FileManager> fileMgrs = new ArrayList<FileManager>();
    private final List<AutoCloseable> itemDataInputFileSlicers = new ArrayList<AutoCloseable>();
    private final List<AutoCloseable> itemInputFileSlicers = new ArrayList<AutoCloseable>();
    private final List<AutoCloseable> itemOutputFileAggregators = new ArrayList<AutoCloseable>();
    private final List<AutoCloseable> opTraceLogFileAggregators = new ArrayList<AutoCloseable>();
    private final List<AutoCloseable> storageAuthFileSlicers = new ArrayList<AutoCloseable>();
    private MetricsAggregator metricsAggregator = null;

    public LoadStepClientBase(Config config, List<Extension> extensions, List<Config> ctxConfigs, MetricsManager metricsMgr) {
        super(config, extensions, ctxConfigs, metricsMgr);
    }

    @Override
    protected final void doStartWrapped() throws IllegalArgumentException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
            this.config.val("load-step-id", this.loadStepId());
            this.config.val("load-step-idAutoGenerated", false);
            List<String> nodeAddrs = LoadStepClientBase.remoteNodeAddrs(this.config);
            LoadStepClientBase.initFileManagers(nodeAddrs, this.fileMgrs);
            int sliceCount = 1 + nodeAddrs.size();
            List<Config> configSlices = this.sliceConfig(this.config, sliceCount);
            this.addFileClients(this.config, configSlices);
            ArrayList<List<Config>> ctxConfigsSlices = new ArrayList<List<Config>>(sliceCount);
            for (int i = 0; i < sliceCount; ++i) {
                ctxConfigsSlices.add(new ArrayList());
            }
            if (null != this.ctxConfigs) {
                for (Config ctxConfig : this.ctxConfigs) {
                    List<Config> ctxConfigSlices = this.sliceConfig(ctxConfig, sliceCount);
                    this.addFileClients(ctxConfig, ctxConfigSlices);
                    for (int i = 0; i < sliceCount; ++i) {
                        ((List)ctxConfigsSlices.get(i)).add(ctxConfigSlices.get(i));
                    }
                }
            }
            this.initAndStartStepSlices(nodeAddrs, configSlices, ctxConfigsSlices, this.metricsMgr);
            this.initAndStartMetricsAggregator();
            Loggers.MSG.info("{}: load step client started, additional nodes: {}", (Object)this.loadStepId(), (Object)Arrays.toString(nodeAddrs.toArray()));
        }
    }

    private static List<String> remoteNodeAddrs(Config config) {
        Config nodeConfig = config.configVal("load-step-node");
        int nodePort = nodeConfig.intVal("port");
        List nodeAddrs = nodeConfig.listVal("addrs");
        return nodeAddrs == null || nodeAddrs.isEmpty() ? Collections.EMPTY_LIST : nodeAddrs.stream().map(addr -> NetUtil.addPortIfMissing(addr, nodePort)).collect(Collectors.toList());
    }

    private static void initFileManagers(List<String> nodeAddrs, List<FileManager> fileMgrsDst) {
        fileMgrsDst.add(FileManager.INSTANCE);
        nodeAddrs.stream().map(FileManagerClient::resolve).forEachOrdered(fileMgrsDst::add);
    }

    private void addFileClients(Config config, List<Config> configSlices) {
        String storageAuthFile;
        Config loadConfig = config.configVal("load");
        int batchSize = loadConfig.intVal("batch-size");
        Config storageConfig = config.configVal("storage");
        Config itemConfig = config.configVal("item");
        Config itemDataConfig = itemConfig.configVal("data");
        boolean verifyFlag = itemDataConfig.boolVal("verify");
        Config itemDataInputConfig = itemDataConfig.configVal("input");
        Config itemDataInputLayerConfig = itemDataInputConfig.configVal("layer");
        Object itemDataInputLayerSizeRaw = itemDataInputLayerConfig.val("size");
        SizeInBytes itemDataLayerSize = itemDataInputLayerSizeRaw instanceof String ? new SizeInBytes((String)itemDataInputLayerSizeRaw) : new SizeInBytes(TypeUtil.typeConvert(itemDataInputLayerSizeRaw, Integer.TYPE).intValue());
        String itemDataInputFile = itemDataInputConfig.stringVal("file");
        String itemDataInputSeed = itemDataInputConfig.stringVal("seed");
        int itemDataInputLayerCacheSize = itemDataInputLayerConfig.intVal("cache");
        try (DataInput dataInput = DataInput.instance(itemDataInputFile, itemDataInputSeed, itemDataLayerSize, itemDataInputLayerCacheSize);
             Object storageDriver = StorageDriver.instance(this.extensions, storageConfig, dataInput, verifyFlag, batchSize, this.loadStepId());
             Input itemInput = ItemInputFactory.createItemInput(itemConfig, batchSize, storageDriver);){
            if (null != itemDataInputFile && !itemDataInputFile.isEmpty()) {
                this.itemDataInputFileSlicers.add(new ItemDataInputFileSlicer(this.loadStepId(), this.fileMgrs, configSlices, itemDataInputFile, batchSize));
                Loggers.MSG.debug("{}: item data input file slicer initialized", (Object)this.loadStepId());
            }
            if (null != itemInput) {
                this.itemInputFileSlicers.add(new ItemInputFileSlicer(this.loadStepId(), this.fileMgrs, configSlices, itemInput, batchSize));
                Loggers.MSG.debug("{}: item input file slicer initialized", (Object)this.loadStepId());
            }
        }
        catch (IllegalConfigurationException e) {
            LogUtil.exception(Level.ERROR, e, "{}: failed to init the storage driver", this.loadStepId());
        }
        catch (InterruptedException e) {
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
        }
        catch (Exception e) {
            LogUtil.exception(Level.WARN, e, "{}: failed to close the item input", this.loadStepId());
        }
        String itemOutputFile = config.stringVal("item-output-file");
        if (itemOutputFile != null && !itemOutputFile.isEmpty()) {
            this.itemOutputFileAggregators.add(new ItemOutputFileAggregator(this.loadStepId(), this.fileMgrs, configSlices, itemOutputFile));
            Loggers.MSG.debug("{}: item output file aggregator initialized", (Object)this.loadStepId());
        }
        if (config.boolVal("output-metrics-trace-persist")) {
            this.opTraceLogFileAggregators.add(new OpTraceLogFileAggregator(this.loadStepId(), this.fileMgrs));
            Loggers.MSG.debug("{}: operation traces log file aggregator initialized", (Object)this.loadStepId());
        }
        if ((storageAuthFile = storageConfig.stringVal("auth-file")) != null && !storageAuthFile.isEmpty()) {
            this.storageAuthFileSlicers.add(new TempInputTextFileSlicer(this.loadStepId(), storageAuthFile, this.fileMgrs, "storage-auth-file", configSlices, batchSize));
            Loggers.MSG.debug("{}: storage auth file slicer initialized", (Object)this.loadStepId());
        }
    }

    private void initAndStartMetricsAggregator() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
            this.metricsAggregator = new MetricsAggregatorImpl(this.loadStepId(), this.stepSlices);
            this.metricsAggregator.start();
        }
        catch (Exception e) {
            LogUtil.exception(Level.ERROR, e, "{}: failed to start the metrics aggregator", this.loadStepId());
        }
    }

    private void initAndStartStepSlices(List<String> nodeAddrs, List<Config> configSlices, List<List<Config>> ctxConfigsSlices, MetricsManager metricsManager) {
        String stepTypeName;
        try {
            stepTypeName = this.getTypeName();
        }
        catch (RemoteException e) {
            throw new AssertionError((Object)e);
        }
        int sliceCount = configSlices.size();
        for (int i = 0; i < sliceCount; ++i) {
            Object stepSlice;
            Config configSlice = configSlices.get(i);
            if (i == 0) {
                stepSlice = LoadStepFactory.createLocalLoadStep(configSlice, this.extensions, ctxConfigsSlices.get(i), metricsManager, stepTypeName);
            } else {
                String nodeAddrWithPort = nodeAddrs.get(i - 1);
                stepSlice = LoadStepSliceUtil.resolveRemote(configSlice, ctxConfigsSlices.get(i), stepTypeName, nodeAddrWithPort);
            }
            this.stepSlices.add((LoadStep)stepSlice);
            if (stepSlice == null) continue;
            try {
                stepSlice.start();
                continue;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
                }
                LogUtil.exception(Level.ERROR, e, "{}: failed to start the step slice \"{}\"", this.loadStepId(), stepSlice);
            }
        }
    }

    private List<Config> sliceConfig(Config config, int sliceCount) {
        ArrayList<Config> configSlices = new ArrayList<Config>(sliceCount);
        for (int i = 0; i < sliceCount; ++i) {
            Config configSlice2 = ConfigSliceUtil.initSlice(config);
            if (i == 0) {
                configSlice2.val("output-metrics-average-period", "0s");
            }
            configSlices.add(configSlice2);
        }
        if (sliceCount > 1) {
            block11: {
                Object sizeLimitRaw;
                long sizeLimit;
                double rateLimit;
                long countFailLimit;
                long countLimit = config.longVal("load-op-limit-count");
                if (countLimit > 0L) {
                    ConfigSliceUtil.sliceLongValue(countLimit, configSlices, "load-op-limit-count");
                    configSlices.stream().mapToLong(configSlice -> configSlice.longVal("load-op-limit-count")).filter(countLimitSlice -> countLimitSlice == 0L).findAny().ifPresent(countLimitSlice -> Loggers.MSG.fatal("{}: the count limit ({}) is too small to be sliced among the {} nodes, the load step won't work correctly", (Object)this.loadStepId(), (Object)countLimit, (Object)sliceCount));
                }
                if ((countFailLimit = config.longVal("load-op-limit-fail-count")) > 0L) {
                    ConfigSliceUtil.sliceLongValue(countFailLimit, configSlices, "load-op-limit-fail-count");
                    configSlices.stream().mapToLong(configSlice -> configSlice.longVal("load-op-limit-fail-count")).filter(failCountLimitSlice -> failCountLimitSlice == 0L).findAny().ifPresent(failCountLimitSlice -> Loggers.MSG.error("{}: the failures count limit ({}) is too small to be sliced among the {} nodes, the load step may not work correctly", (Object)this.loadStepId(), (Object)countLimit, (Object)sliceCount));
                }
                if ((rateLimit = config.doubleVal("load-op-limit-rate")) > 0.0) {
                    ConfigSliceUtil.sliceDoubleValue(rateLimit, configSlices, "load-op-limit-rate");
                }
                if ((sizeLimit = (sizeLimitRaw = config.val("load-step-limit-size")) instanceof String ? SizeInBytes.toFixedSize((String)sizeLimitRaw) : TypeUtil.typeConvert(sizeLimitRaw, Long.TYPE)) > 0L) {
                    ConfigSliceUtil.sliceLongValue(sizeLimit, configSlices, "load-step-limit-size");
                }
                try {
                    Config storageNetNodeConfig = config.configVal("storage-net-node");
                    boolean sliceStorageNodesFlag = storageNetNodeConfig.boolVal("slice");
                    if (sliceStorageNodesFlag) {
                        List<String> storageNodeAddrs = storageNetNodeConfig.listVal("addrs");
                        ConfigSliceUtil.sliceStorageNodeAddrs(configSlices, storageNodeAddrs);
                    }
                }
                catch (NoSuchElementException storageNetNodeConfig) {
                }
                catch (InvalidValueTypeException e) {
                    if (null == e.actualType()) break block11;
                    LogUtil.exception(Level.ERROR, e, "Failed to assign the storage endpoints to the nodes", new Object[0]);
                }
            }
            ConfigSliceUtil.sliceItemNaming(configSlices);
        }
        return configSlices;
    }

    private int sliceCount() {
        return this.stepSlices.size();
    }

    @Override
    protected final void initMetrics(int originIndex, OpType opType, int concurrencyLimit, Config metricsConfig, SizeInBytes itemDataSize, boolean outputColorFlag) {
        int concurrencyThreshold = (int)((double)concurrencyLimit * metricsConfig.doubleVal("threshold"));
        boolean metricsAvgPersistFlag = metricsConfig.boolVal("average-persist");
        boolean metricsSumPersistFlag = metricsConfig.boolVal("summary-persist");
        DistributedMetricsContext metricsCtx = (DistributedMetricsContext)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)DistributedMetricsContextImpl.builder().loadStepId(this.loadStepId())).opType(opType)).nodeCountSupplier(this::sliceCount).concurrencyLimit(concurrencyLimit)).concurrencyThreshold(concurrencyThreshold)).itemDataSize(itemDataSize)).outputPeriodSec(this.avgPeriod(metricsConfig))).stdOutColorFlag(outputColorFlag)).avgPersistFlag(metricsAvgPersistFlag).sumPersistFlag(metricsSumPersistFlag).snapshotsSupplier(() -> this.metricsSnapshotsByIndex(originIndex)).quantileValues(this.quantiles(metricsConfig)).nodeAddrs(LoadStepClientBase.remoteNodeAddrs(this.config)).comment(this.config.stringVal("run-comment"))).runId(this.runId())).build();
        this.metricsContexts.add(metricsCtx);
    }

    private List<Double> quantiles(Config metricsConfig) {
        return metricsConfig.listVal("quantiles").stream().map(v -> Double.valueOf(v.toString())).collect(Collectors.toList());
    }

    private List<AllMetricsSnapshot> metricsSnapshotsByIndex(int originIndex) {
        return this.metricsAggregator == null ? Collections.emptyList() : this.metricsAggregator.metricsSnapshotsByIndex(originIndex);
    }

    @Override
    protected final void doShutdown() {
        this.stepSlices.parallelStream().forEach(stepSlice -> {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
                stepSlice.shutdown();
            }
            catch (RemoteException e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to shutdown the step service {}", this.loadStepId(), stepSlice);
            }
        });
    }

    @Override
    public final boolean await(long timeout, TimeUnit timeUnit) throws IllegalStateException, InterruptedException {
        int stepSliceCount = this.stepSlices.size();
        try {
            CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());
            try {
                if (0 == stepSliceCount) {
                    throw new IllegalStateException("No step slices are available");
                }
                Loggers.MSG.debug("{}: await for {} step slices for at most {} {}...", (Object)this.loadStepId(), (Object)stepSliceCount, (Object)timeout, (Object)timeUnit.name().toLowerCase());
                boolean bl = this.stepSlices.parallelStream().map(stepSlice -> {
                    try {
                        return stepSlice.await(timeout, timeUnit);
                    }
                    catch (InterruptedException e) {
                        com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                    return false;
                }).reduce((flag1, flag2) -> flag1 != false && flag2 != false).orElse(false);
                if (logCtx != null) {
                    logCtx.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (logCtx != null) {
                    try {
                        logCtx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Loggers.MSG.info("{}: await for {} step slices done", (Object)this.loadStepId(), (Object)stepSliceCount);
        }
    }

    @Override
    protected final void doStop() {
        this.stepSlices.parallelStream().forEach(stepSlice -> {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", stepSlice.loadStepId()).put("class_name", this.getClass().getSimpleName());){
                stepSlice.stop();
            }
            catch (Exception e) {
                Exceptions.throwUncheckedIfInterrupted(e);
                LogUtil.trace(Loggers.ERR, Level.WARN, e, "{}: failed to stop the step slice \"{}\"", this.loadStepId(), stepSlice);
            }
        });
        if (null != this.metricsAggregator) {
            try {
                this.metricsAggregator.stop();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.doStop();
    }

    @Override
    protected final void doClose() throws IOException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
            super.doClose();
            if (null != this.metricsAggregator) {
                this.metricsAggregator.close();
                this.metricsAggregator = null;
            }
            this.stepSlices.parallelStream().forEach(stepSlice -> {
                try {
                    stepSlice.close();
                    Loggers.MSG.debug("{}: step slice \"{}\" closed", (Object)this.loadStepId(), stepSlice);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the step service \"{}\"", this.loadStepId(), stepSlice);
                }
            });
            Loggers.MSG.debug("{}: closed all {} step slices", (Object)this.loadStepId(), (Object)this.stepSlices.size());
            this.stepSlices.clear();
            this.itemDataInputFileSlicers.forEach(itemDataInputFileSlicer -> {
                try {
                    itemDataInputFileSlicer.close();
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the item data input file slicer \"{}\"", this.loadStepId(), itemDataInputFileSlicer);
                }
            });
            this.itemDataInputFileSlicers.clear();
            this.itemInputFileSlicers.forEach(itemInputFileSlicer -> {
                try {
                    itemInputFileSlicer.close();
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the item input file slicer \"{}\"", this.loadStepId(), itemInputFileSlicer);
                }
            });
            this.itemInputFileSlicers.clear();
            this.itemOutputFileAggregators.parallelStream().forEach(itemOutputFileAggregator -> {
                try {
                    itemOutputFileAggregator.close();
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the item output file aggregator \"{}\"", this.loadStepId(), itemOutputFileAggregator);
                }
            });
            this.itemOutputFileAggregators.clear();
            this.opTraceLogFileAggregators.parallelStream().forEach(opTraceLogFileAggregator -> {
                try {
                    opTraceLogFileAggregator.close();
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the operation traces log file aggregator \"{}\"", this.loadStepId(), opTraceLogFileAggregator);
                }
            });
            this.opTraceLogFileAggregators.clear();
            this.storageAuthFileSlicers.forEach(storageAuthFileSlicer -> {
                try {
                    storageAuthFileSlicer.close();
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.WARN, e, "{}: failed to close the storage auth file slicer \"{}\"", this.loadStepId(), storageAuthFileSlicer);
                }
            });
            this.storageAuthFileSlicers.clear();
        }
    }

    @Override
    public final <T extends LoadStepClient> T config(Map<String, Object> configMap) {
        if (this.ctxConfigs != null) {
            throw new IllegalStateException("config(...) should be invoked before any append(...) call");
        }
        BasicConfig configCopy = new BasicConfig(this.config);
        HashMap<String, String> argValPairs = new HashMap<String, String>();
        ConfigUtil.flatten(configMap, argValPairs, this.config.pathSep(), null);
        List<Map<String, Object>> aliasingConfig = this.config.listVal("aliasing");
        try {
            Map<String, String> aliasedArgs = AliasingUtil.apply(argValPairs, aliasingConfig);
            if (this.config.boolVal("load-step-idAutoGenerated") && aliasedArgs.get("load-step-id") != null) {
                configCopy.val("load-step-idAutoGenerated", false);
            }
            aliasedArgs.forEach(configCopy::val);
        }
        catch (Exception e) {
            LogUtil.exception(Level.FATAL, e, "Scenario syntax error", new Object[0]);
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
        }
        return this.copyInstance(configCopy, null);
    }

    @Override
    public final <T extends LoadStepClient> T append(Map<String, Object> context) {
        List<Object> ctxConfigsCopy = this.ctxConfigs == null ? new ArrayList(1) : this.ctxConfigs.stream().map(BasicConfig::new).collect(Collectors.toList());
        HashMap<String, String> argValPairs = new HashMap<String, String>();
        ConfigUtil.flatten(context, argValPairs, this.config.pathSep(), null);
        List<Map<String, Object>> aliasingConfig = this.config.listVal("aliasing");
        BasicConfig ctxConfig = new BasicConfig(this.config);
        try {
            Map<String, String> aliasedArgs = AliasingUtil.apply(argValPairs, aliasingConfig);
            aliasedArgs.forEach(ctxConfig::val);
        }
        catch (Exception e) {
            LogUtil.exception(Level.FATAL, e, "Scenario syntax error", new Object[0]);
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
        }
        ctxConfigsCopy.add(ctxConfig);
        return this.copyInstance(this.config, ctxConfigsCopy);
    }

    protected abstract <T extends LoadStepClient> T copyInstance(Config var1, List<Config> var2);
}

