/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client.metrics;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.ServiceTaskExecutor;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.client.metrics.MetricsSnapshotsSupplierTask;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.github.akurilov.fiber4j.ExclusiveFiberBase;
import com.github.akurilov.fiber4j.FibersExecutor;
import java.util.List;
import org.apache.logging.log4j.Level;

public final class MetricsSnapshotsSupplierTaskImpl
extends ExclusiveFiberBase
implements MetricsSnapshotsSupplierTask {
    private final LoadStep loadStep;
    private volatile List<? extends AllMetricsSnapshot> snapshotsByOrigin = null;
    private volatile boolean failedBeforeFlag = false;

    public MetricsSnapshotsSupplierTaskImpl(LoadStep loadStep) {
        this(ServiceTaskExecutor.INSTANCE, loadStep);
    }

    public MetricsSnapshotsSupplierTaskImpl(FibersExecutor executor, LoadStep loadStep) {
        super(executor);
        this.loadStep = loadStep;
    }

    @Override
    protected final void invokeTimedExclusively(long startTimeNanos) {
        try {
            this.snapshotsByOrigin = this.loadStep.metricsSnapshots();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted(e);
            LogUtil.exception(Level.INFO, e, "Failed to fetch the metrics snapshots from \"{}\"", this.loadStep);
            if (this.failedBeforeFlag) {
                LogUtil.exception(Level.WARN, e, "Failed to fetch the metrics snapshots from \"{}\" twice, stopping", this.loadStep);
                this.stop();
            }
            this.failedBeforeFlag = true;
        }
    }

    @Override
    public final List<? extends AllMetricsSnapshot> get() {
        return this.snapshotsByOrigin;
    }

    @Override
    protected final void doClose() {
        if (null != this.snapshotsByOrigin) {
            this.snapshotsByOrigin.clear();
        }
    }
}

