/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.file;

import com.emc.mongoose.base.load.step.file.FileManager;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.async.AsyncLogger;

public class FileManagerImpl
implements FileManager {
    static final String LOG_CONFIG_STEP_ID_PTRN = "${ctx:step_id}";

    @Override
    public final String logFileName(String loggerName, String testStepId) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", testStepId);){
            Logger logger = LogManager.getLogger(loggerName);
            Appender appender = ((AsyncLogger)logger).getAppenders().get("opTraceFile");
            String filePtrn = ((RollingRandomAccessFileAppender)appender).getFilePattern();
            String string = filePtrn.contains(LOG_CONFIG_STEP_ID_PTRN) ? filePtrn.replace(LOG_CONFIG_STEP_ID_PTRN, testStepId) : filePtrn;
            return string;
        }
    }

    @Override
    public final String newTmpFileName() throws IOException {
        if (!Files.exists(TMP_DIR, new LinkOption[0])) {
            Files.createDirectories(TMP_DIR, new FileAttribute[0]);
        }
        return Paths.get(TMP_DIR.toString(), Long.toString(System.nanoTime())).toString();
    }

    @Override
    public final byte[] readFromFile(String fileName, long offset) throws IOException {
        try (SeekableByteChannel fileChannel = Files.newByteChannel(Paths.get(fileName, new String[0]), READ_OPTIONS);){
            fileChannel.position(offset);
            long remainingSize = fileChannel.size() - offset;
            if (remainingSize <= 0L) {
                throw new EOFException();
            }
            int buffSize = (int)Math.min(0x1000000L, remainingSize);
            if (buffSize > 0) {
                int n;
                ByteBuffer bb = ByteBuffer.allocate(buffSize);
                for (int doneSize = 0; doneSize < buffSize; doneSize += n) {
                    n = fileChannel.read(bb);
                    if (n >= 0) continue;
                    byte[] buff = new byte[bb.position()];
                    bb.rewind();
                    bb.get(buff);
                    byte[] byArray = buff;
                    return byArray;
                }
                byte[] byArray = bb.array();
                return byArray;
            }
            byte[] byArray = EMPTY;
            return byArray;
        }
    }

    @Override
    public final void writeToFile(String fileName, byte[] buff) throws IOException {
        try (SeekableByteChannel fileChannel = Files.newByteChannel(Paths.get(fileName, new String[0]), APPEND_OPEN_OPTIONS);){
            ByteBuffer bb = ByteBuffer.wrap(buff);
            int n = 0;
            while (n < buff.length) {
                n = fileChannel.write(bb);
            }
        }
    }

    @Override
    public final long fileSize(String fileName) {
        return new File(fileName).length();
    }

    @Override
    public final void truncateFile(String fileName, long size) throws IOException {
        try (SeekableByteChannel fileChannel = Files.newByteChannel(Paths.get(fileName, new String[0]), WRITE_OPEN_OPTIONS);){
            fileChannel.truncate(size);
        }
    }

    @Override
    public final void deleteFile(String fileName) throws IOException {
        if (!new File(fileName).delete()) {
            throw new FileSystemException(fileName, null, "Failed to delete");
        }
    }
}

