/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.linear;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.ItemType;
import com.emc.mongoose.base.item.io.ItemInfoFileOutput;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.generator.LoadGeneratorBuilder;
import com.emc.mongoose.base.load.generator.LoadGeneratorBuilderImpl;
import com.emc.mongoose.base.load.step.local.LoadStepLocalBase;
import com.emc.mongoose.base.load.step.local.context.LoadStepContextImpl;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.concurrent.throttle.RateThrottle;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.Level;

public class LinearLoadStepLocal
extends LoadStepLocalBase {
    public LinearLoadStepLocal(Config baseConfig, List<Extension> extensions, List<Config> contexts, MetricsManager metricsManager) {
        super(baseConfig, extensions, contexts, metricsManager);
    }

    @Override
    public String getTypeName() {
        return "Load";
    }

    @Override
    protected void init() {
        String autoStepId = "linear_" + LogUtil.getDateTimeStamp();
        if (this.config.boolVal("load-step-idAutoGenerated")) {
            this.config.val("load-step-id", autoStepId);
        }
        Config loadConfig = this.config.configVal("load");
        Config opConfig = loadConfig.configVal("op");
        Config stepConfig = loadConfig.configVal("step");
        OpType opType = OpType.valueOf(opConfig.stringVal("type").toUpperCase());
        Config storageConfig = this.config.configVal("storage");
        int concurrencyLimit = storageConfig.intVal("driver-limit-concurrency");
        Config outputConfig = this.config.configVal("output");
        Config metricsConfig = outputConfig.configVal("metrics");
        Object itemDataSizeRaw = this.config.val("item-data-size");
        SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(TypeUtil.typeConvert(itemDataSizeRaw, Long.TYPE));
        boolean originIndex = false;
        boolean outputColorFlag = outputConfig.boolVal("color");
        this.initMetrics(0, opType, concurrencyLimit, metricsConfig, itemDataSize, outputColorFlag);
        Config itemConfig = this.config.configVal("item");
        Config dataConfig = itemConfig.configVal("data");
        Config dataInputConfig = dataConfig.configVal("input");
        Config dataLayerConfig = dataInputConfig.configVal("layer");
        String testStepId = stepConfig.stringVal("id");
        try {
            Object dataLayerSizeRaw = dataLayerConfig.val("size");
            SizeInBytes dataLayerSize = dataLayerSizeRaw instanceof String ? new SizeInBytes((String)dataLayerSizeRaw) : new SizeInBytes(TypeUtil.typeConvert(dataLayerSizeRaw, Integer.TYPE).intValue());
            DataInput dataInput = DataInput.instance(dataInputConfig.stringVal("file"), dataInputConfig.stringVal("seed"), dataLayerSize, dataLayerConfig.intVal("cache"));
            int batchSize = loadConfig.intVal("batch-size");
            try {
                Object driver = StorageDriver.instance(this.extensions, storageConfig, dataInput, dataConfig.boolVal("verify"), batchSize, testStepId);
                ItemType itemType = ItemType.valueOf(itemConfig.stringVal("type").toUpperCase());
                Object itemFactory = ItemType.getItemFactory(itemType);
                double rateLimit = opConfig.doubleVal("limit-rate");
                try {
                    LoadGeneratorBuilder generatorBuilder = ((LoadGeneratorBuilderImpl)((LoadGeneratorBuilderImpl)((LoadGeneratorBuilderImpl)((LoadGeneratorBuilderImpl)((LoadGeneratorBuilderImpl)((LoadGeneratorBuilderImpl)new LoadGeneratorBuilderImpl().itemConfig(itemConfig)).loadConfig(loadConfig)).itemType(itemType)).itemFactory((ItemFactory)itemFactory)).loadOperationsOutput((Output)driver)).authConfig(storageConfig.configVal("auth"))).originIndex(0);
                    if (rateLimit > 0.0) {
                        generatorBuilder.addThrottle(new RateThrottle(rateLimit));
                    }
                    Object generator = generatorBuilder.build();
                    LoadStepContextImpl stepCtx = new LoadStepContextImpl(testStepId, generator, driver, (MetricsContext)this.metricsContexts.get(0), loadConfig, outputConfig.boolVal("metrics-trace-persist"));
                    this.stepContexts.add(stepCtx);
                    String itemOutputFile = itemConfig.stringVal("output-file");
                    if (itemOutputFile != null && itemOutputFile.length() > 0) {
                        Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                        if (Files.exists(itemOutputPath, new LinkOption[0])) {
                            Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                        }
                        try {
                            ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                            stepCtx.operationsResultsOutput(itemOutput);
                        }
                        catch (IOException e) {
                            LogUtil.exception(Level.ERROR, e, "Failed to initialize the item output, the processed items info won't be persisted", new Object[0]);
                        }
                    }
                }
                catch (IllegalConfigurationException e) {
                    throw new IllegalStateException("Failed to initialize the load generator", e);
                }
            }
            catch (IllegalConfigurationException e) {
                throw new IllegalStateException("Failed to initialize the storage driver", e);
            }
            catch (InterruptedException e) {
                Exceptions.throwUnchecked(e);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the data input", e);
        }
    }
}

