/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.local;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.LoadStepBase;
import com.emc.mongoose.base.load.step.local.context.LoadStepContext;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.MetricsContextImpl;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class LoadStepLocalBase
extends LoadStepBase {
    protected final List<LoadStepContext> stepContexts = new ArrayList<LoadStepContext>();

    protected LoadStepLocalBase(Config baseConfig, List<Extension> extensions, List<Config> contextConfigs, MetricsManager metricsManager) {
        super(baseConfig, extensions, contextConfigs, metricsManager);
    }

    @Override
    protected void doStartWrapped() {
        this.stepContexts.forEach(stepCtx -> {
            try {
                stepCtx.start();
            }
            catch (RemoteException remoteException) {
            }
            catch (IllegalStateException e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to start the load step context \"{}\"", this.loadStepId(), stepCtx);
            }
        });
    }

    @Override
    protected final void initMetrics(int originIndex, OpType opType, int concurrency, Config metricsConfig, SizeInBytes itemDataSize, boolean outputColorFlag) {
        int index = this.metricsContexts.size();
        Object metricsCtx = MetricsContextImpl.builder().loadStepId(this.loadStepId()).opType(opType).actualConcurrencyGauge(() -> this.stepContexts.get(index).activeOpCount()).concurrencyLimit(concurrency).concurrencyThreshold((int)((double)concurrency * metricsConfig.doubleVal("threshold"))).itemDataSize(itemDataSize).outputPeriodSec(this.avgPeriod(metricsConfig)).stdOutColorFlag(outputColorFlag).comment(this.config.stringVal("run-comment")).runId(this.runId()).build();
        this.metricsContexts.add(metricsCtx);
    }

    @Override
    protected final void doShutdown() {
        this.stepContexts.forEach(stepCtx -> {
            try (CloseableThreadContext.Instance ctx = CloseableThreadContext.put("step_id", this.loadStepId()).put("class_name", this.getClass().getSimpleName());){
                stepCtx.shutdown();
                Loggers.MSG.debug("{}: load step context shutdown", (Object)this.loadStepId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    @Override
    public final boolean await(long timeout, TimeUnit timeUnit) throws IllegalStateException {
        long timeoutMillis = timeout > 0L ? timeUnit.toMillis(timeout) : Long.MAX_VALUE;
        long startTimeMillis = System.currentTimeMillis();
        int stepCtxCount = this.stepContexts.size();
        LoadStepContext[] stepContextsCopy = this.stepContexts.toArray(new LoadStepContext[stepCtxCount]);
        int countDown = stepCtxCount;
        boolean timeIsOut = false;
        block3: while (countDown > 0 && !timeIsOut) {
            for (int i = 0; i < stepCtxCount; ++i) {
                if (timeoutMillis <= System.currentTimeMillis() - startTimeMillis) {
                    timeIsOut = true;
                    continue block3;
                }
                LoadStepContext stepCtx = stepContextsCopy[i];
                if (stepCtx == null) continue;
                try {
                    if (!stepCtx.isDone() && !stepCtx.await(10000000L, TimeUnit.NANOSECONDS)) continue;
                    stepContextsCopy[i] = null;
                    --countDown;
                    continue block3;
                }
                catch (InterruptedException e) {
                    Exceptions.throwUnchecked(e);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return 0 == countDown;
    }

    @Override
    protected final void doStop() {
        this.stepContexts.forEach(LoadStepContext::stop);
        super.doStop();
    }

    @Override
    protected final void doClose() throws IOException {
        super.doClose();
        this.stepContexts.parallelStream().filter(Objects::nonNull).forEach(stepCtx -> {
            try {
                stepCtx.close();
            }
            catch (IOException e) {
                LogUtil.exception(Level.ERROR, e, "Failed to close the load step context \"{}\"", stepCtx.toString());
            }
        });
        this.stepContexts.clear();
    }
}

