/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.local.context;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.DaemonBase;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.composite.CompositeOperation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.item.op.partial.PartialOperation;
import com.emc.mongoose.base.item.op.path.PathOperation;
import com.emc.mongoose.base.load.generator.LoadGenerator;
import com.emc.mongoose.base.load.step.local.context.LoadStepContext;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.logging.OperationTraceCsvBatchLogMessage;
import com.emc.mongoose.base.logging.OperationTraceCsvLogMessage;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.concurrent.AsyncRunnable;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class LoadStepContextImpl<I extends Item, O extends Operation<I>>
extends DaemonBase
implements LoadStepContext<I, O> {
    private final String id;
    private final LoadGenerator<I, O> generator;
    private final StorageDriver<I, O> driver;
    private final long countLimit;
    private final long sizeLimit;
    private final long failCountLimit;
    private final boolean failRateLimitFlag;
    private final ConcurrentMap<I, O> latestSuccOpResultByItem;
    private final boolean recycleFlag;
    private final boolean retryFlag;
    private final MetricsContext metricsCtx;
    private final LongAdder counterResults = new LongAdder();
    private final boolean tracePersistFlag;
    private final int batchSize;
    private volatile Output<O> opsResultsOutput;

    public LoadStepContextImpl(String id, LoadGenerator<I, O> generator, StorageDriver<I, O> driver, MetricsContext metricsCtx, Config loadConfig, boolean tracePersistFlag) {
        this.id = id;
        this.generator = generator;
        this.driver = driver;
        this.driver.operationResultOutput(this);
        this.metricsCtx = metricsCtx;
        this.tracePersistFlag = tracePersistFlag;
        this.batchSize = loadConfig.intVal("batch-size");
        Config opConfig = loadConfig.configVal("op");
        this.recycleFlag = opConfig.boolVal("recycle");
        this.retryFlag = opConfig.boolVal("retry");
        Config opLimitConfig = opConfig.configVal("limit");
        int recycleLimit = opLimitConfig.intVal("recycle");
        this.latestSuccOpResultByItem = this.recycleFlag || this.retryFlag ? new ConcurrentHashMap<I, O>(recycleLimit) : null;
        long configCountLimit = opLimitConfig.longVal("count");
        this.countLimit = configCountLimit > 0L ? configCountLimit : Long.MAX_VALUE;
        Config stepLimitConfig = loadConfig.configVal("step-limit");
        Object configSizeLimitRaw = stepLimitConfig.val("size");
        SizeInBytes configSizeLimit = configSizeLimitRaw instanceof String ? new SizeInBytes((String)configSizeLimitRaw) : new SizeInBytes(TypeUtil.typeConvert(configSizeLimitRaw, Long.TYPE));
        this.sizeLimit = configSizeLimit.get() > 0L ? configSizeLimit.get() : Long.MAX_VALUE;
        Config failConfig = opLimitConfig.configVal("fail");
        long configFailCount = failConfig.longVal("count");
        this.failCountLimit = configFailCount > 0L ? configFailCount : Long.MAX_VALUE;
        this.failRateLimitFlag = failConfig.boolVal("rate");
    }

    @Override
    public boolean isDone() {
        if (!AsyncRunnable.State.STARTED.equals((Object)this.state()) && !AsyncRunnable.State.SHUTDOWN.equals((Object)this.state())) {
            Loggers.MSG.debug("{}: done due to {} state", (Object)this.id, (Object)this.state());
            return true;
        }
        if (this.isDoneCountLimit()) {
            Loggers.MSG.debug("{}: done due to max count ({}) done state", (Object)this.id, (Object)this.countLimit);
            return true;
        }
        if (this.isDoneSizeLimit()) {
            Loggers.MSG.debug("{}: done due to max size done state", (Object)this.id);
            return true;
        }
        if (this.isFailThresholdReached()) {
            Loggers.ERR.warn("{}: done due to \"BAD\" state", (Object)this.id);
            return true;
        }
        if (!this.recycleFlag && this.allOperationsCompleted()) {
            Loggers.MSG.debug("{}: done due to all {} load operations have been completed", (Object)this.id, (Object)this.generator.generatedOpCount());
            return true;
        }
        if (this.isNothingToRecycle()) {
            Loggers.ERR.warn("{}: no load operations to recycle (all failed?)", (Object)this.id);
            return true;
        }
        return false;
    }

    private boolean isDoneCountLimit() {
        if (this.countLimit > 0L) {
            long failCountSum;
            if (this.counterResults.sum() >= this.countLimit) {
                Loggers.MSG.debug("{}: count limit reached, {} results >= {} limit", (Object)this.id, (Object)this.counterResults.sum(), (Object)this.countLimit);
                return true;
            }
            Object lastStats = this.metricsCtx.lastSnapshot();
            long succCountSum = lastStats.successSnapshot().count();
            if (succCountSum + (failCountSum = lastStats.failsSnapshot().count()) >= this.countLimit) {
                Loggers.MSG.debug("{}: count limit reached, {} successful + {} failed >= {} limit", (Object)this.id, (Object)succCountSum, (Object)failCountSum, (Object)this.countLimit);
                return true;
            }
        }
        return false;
    }

    private boolean isDoneSizeLimit() {
        long sizeSum;
        if (this.sizeLimit > 0L && (sizeSum = this.metricsCtx.lastSnapshot().byteSnapshot().count()) >= this.sizeLimit) {
            Loggers.MSG.debug("{}: size limit reached, done {} >= {} limit", (Object)this.id, (Object)SizeInBytes.formatFixedSize(sizeSum), (Object)this.sizeLimit);
            return true;
        }
        return false;
    }

    private boolean allOperationsCompleted() {
        try {
            if (this.generator.isStopped()) {
                return this.counterResults.longValue() >= this.generator.generatedOpCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private boolean isNothingToRecycle() {
        long resultCount = this.counterResults.sum();
        return this.recycleFlag && this.generator.isNothingToRecycle() && resultCount > 0L && resultCount >= this.generator.generatedOpCount() && this.latestSuccOpResultByItem.size() == 0;
    }

    private boolean isFailThresholdReached() {
        Object allMetricsSnapshot = this.metricsCtx.lastSnapshot();
        long failCountSum = allMetricsSnapshot.failsSnapshot().count();
        double failRateLast = allMetricsSnapshot.failsSnapshot().last();
        double succRateLast = allMetricsSnapshot.successSnapshot().last();
        if (failCountSum > this.failCountLimit) {
            Loggers.ERR.warn("{}: failure count ({}) is more than the configured limit ({}), stopping the step", (Object)this.id, (Object)failCountSum, (Object)this.failCountLimit);
            return true;
        }
        if (this.failRateLimitFlag && failRateLast > succRateLast) {
            Loggers.ERR.warn("{}: failures rate ({} failures/sec) is more than success rate ({} op/sec), stopping the step", (Object)this.id, (Object)failRateLast, (Object)succRateLast);
            return true;
        }
        return false;
    }

    private boolean isIdle() throws ConcurrentModificationException {
        try {
            if (!this.generator.isStopped() && !this.generator.isClosed()) {
                return false;
            }
            if (!(this.driver.isStopped() || this.driver.isClosed() || this.driver.isIdle())) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public final void operationsResultsOutput(Output<O> opsResultsOutput) {
        this.opsResultsOutput = opsResultsOutput;
    }

    @Override
    public final int activeOpCount() {
        return this.driver.activeOpCount();
    }

    @Override
    public final boolean put(O opResult) {
        ThreadContext.put("step_id", this.id);
        if (this.tracePersistFlag) {
            Loggers.OP_TRACES.info(new OperationTraceCsvLogMessage(opResult));
        }
        if (opResult instanceof CompositeOperation && !((CompositeOperation)opResult).allSubOperationsDone()) {
            return true;
        }
        Operation.Status status = opResult.status();
        if (Operation.Status.SUCC.equals((Object)status)) {
            long reqDuration = opResult.duration();
            long respLatency = opResult.latency();
            long countBytesDone = opResult instanceof DataOperation ? ((DataOperation)opResult).countBytesDone() : (opResult instanceof PathOperation ? ((PathOperation)opResult).countBytesDone() : 0L);
            if (opResult instanceof PartialOperation) {
                this.metricsCtx.markPartSucc(countBytesDone, reqDuration, respLatency);
            } else {
                if (this.recycleFlag) {
                    this.latestSuccOpResultByItem.put(opResult.item(), opResult);
                    this.generator.recycle(opResult);
                } else {
                    Output<O> opsResultsOutput = this.opsResultsOutput;
                    if (opsResultsOutput != null) {
                        try {
                            if (!opsResultsOutput.put(opResult)) {
                                Loggers.ERR.warn("Failed to output the I/O result");
                            }
                        }
                        catch (Exception e) {
                            Exceptions.throwUncheckedIfInterrupted(e);
                            if (e instanceof EOFException) {
                                LogUtil.exception(Level.DEBUG, e, "Load operations results destination end of input", new Object[0]);
                            }
                            if (e instanceof IOException) {
                                LogUtil.exception(Level.WARN, e, "Failed to put the load operation to the destination", new Object[0]);
                            }
                            throw e;
                        }
                    }
                }
                this.metricsCtx.markSucc(countBytesDone, reqDuration, respLatency);
                this.counterResults.increment();
            }
        } else {
            if (this.recycleFlag) {
                this.latestSuccOpResultByItem.remove(opResult.item());
            }
            if (!Operation.Status.INTERRUPTED.equals((Object)status)) {
                if (this.retryFlag) {
                    this.generator.recycle(opResult);
                } else {
                    Loggers.ERR.debug("{}: {}", (Object)opResult.toString(), (Object)status.toString());
                    this.metricsCtx.markFail();
                    this.counterResults.increment();
                }
            }
        }
        return true;
    }

    @Override
    public final int put(List<O> opResults, int from, int to) {
        int i;
        ThreadContext.put("step_id", this.id);
        if (this.tracePersistFlag) {
            Loggers.OP_TRACES.info(new OperationTraceCsvBatchLogMessage(opResults, from, to));
        }
        long countBytesDone = 0L;
        for (i = from; i < to; ++i) {
            Operation opResult = (Operation)opResults.get(i);
            if (opResult instanceof CompositeOperation && !((CompositeOperation)opResult).allSubOperationsDone()) continue;
            Operation.Status status = opResult.status();
            long reqDuration = opResult.duration();
            long respLatency = opResult.latency();
            if (opResult instanceof DataOperation) {
                countBytesDone = ((DataOperation)opResult).countBytesDone();
            } else if (opResult instanceof PathOperation) {
                countBytesDone = ((PathOperation)opResult).countBytesDone();
            }
            if (Operation.Status.SUCC.equals((Object)status)) {
                if (opResult instanceof PartialOperation) {
                    this.metricsCtx.markPartSucc(countBytesDone, reqDuration, respLatency);
                    continue;
                }
                if (this.recycleFlag) {
                    this.latestSuccOpResultByItem.put(opResult.item(), opResult);
                    this.generator.recycle(opResult);
                } else {
                    Output<O> opsResultsOutput = this.opsResultsOutput;
                    if (opsResultsOutput != null) {
                        try {
                            if (!opsResultsOutput.put(opResult)) {
                                Loggers.ERR.warn("Failed to output the op result");
                            }
                        }
                        catch (Exception e) {
                            Exceptions.throwUncheckedIfInterrupted(e);
                            if (e instanceof EOFException) {
                                LogUtil.exception(Level.DEBUG, e, "Load operations results destination end of input", new Object[0]);
                            }
                            if (e instanceof IOException) {
                                LogUtil.exception(Level.WARN, e, "Failed to put the load operation result to the destination", new Object[0]);
                            }
                            throw e;
                        }
                    }
                }
                this.metricsCtx.markSucc(countBytesDone, reqDuration, respLatency);
                this.counterResults.increment();
                continue;
            }
            if (this.recycleFlag) {
                this.latestSuccOpResultByItem.remove(opResult.item());
            }
            if (Operation.Status.INTERRUPTED.equals((Object)status)) continue;
            if (this.retryFlag) {
                this.generator.recycle(opResult);
                continue;
            }
            Loggers.ERR.debug("{}: {}", (Object)opResult.toString(), (Object)status.toString());
            this.metricsCtx.markFail();
            this.counterResults.increment();
        }
        return i - from;
    }

    @Override
    public final int put(List<O> opsResults) {
        return this.put(opsResults, 0, opsResults.size());
    }

    @Override
    protected void doStart() throws IllegalStateException {
        try {
            this.driver.start();
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalStateException e) {
            LogUtil.exception(Level.WARN, e, "{}: failed to start the storage driver \"{}\"", this.id, this.driver);
        }
        try {
            this.generator.start();
        }
        catch (RemoteException e) {
        }
        catch (IllegalStateException e) {
            LogUtil.exception(Level.WARN, e, "{}: failed to start the load generator \"{}\"", this.id, this.generator);
        }
    }

    @Override
    protected final void doShutdown() {
        CloseableThreadContext.Instance ctx2;
        try {
            ctx2 = CloseableThreadContext.put("step_id", this.id).put("class_name", this.getClass().getSimpleName());
            try {
                this.generator.stop();
                Loggers.MSG.debug("{}: load generator \"{}\" stopped", (Object)this.id, (Object)this.generator.toString());
            }
            finally {
                if (ctx2 != null) {
                    ctx2.close();
                }
            }
        }
        catch (RemoteException ctx2) {
            // empty catch block
        }
        try {
            ctx2 = CloseableThreadContext.put("step_id", this.id).put("class_name", this.getClass().getSimpleName());
            try {
                this.driver.shutdown();
                Loggers.MSG.debug("{}: storage driver {} shutdown", (Object)this.id, (Object)this.driver.toString());
            }
            finally {
                if (ctx2 != null) {
                    ctx2.close();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected final void doStop() throws IllegalStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected final void doClose() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.id).put("class_name", this.getClass().getSimpleName());){
            try {
                this.generator.close();
            }
            catch (IOException e) {
                LogUtil.exception(Level.ERROR, e, "Failed to close the load generator \"{}\"", this.generator.toString());
            }
            try {
                this.driver.close();
            }
            catch (IOException e) {
                LogUtil.exception(Level.ERROR, e, "Failed to close the storage driver \"{}\"", this.driver.toString());
            }
            Loggers.MSG.debug("{}: closed the load step context", (Object)this.id);
        }
    }
}

