/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.service;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.LoadStepFactory;
import com.emc.mongoose.base.load.step.service.LoadStepService;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.svc.ServiceBase;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.CloseableThreadContext;

public final class LoadStepServiceImpl
extends ServiceBase
implements LoadStepService {
    private final LoadStep localLoadStep;

    public LoadStepServiceImpl(int port, List<Extension> extensions, String stepType, Config baseConfig, List<Config> ctxConfigs, MetricsManager metricsManager) {
        super(port);
        baseConfig.val("load-step-idAutoGenerated", false);
        this.localLoadStep = LoadStepFactory.createLocalLoadStep(baseConfig, extensions, ctxConfigs, metricsManager, stepType);
        String stepId = baseConfig.stringVal("load-step-id");
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", stepId).put("class_name", this.getClass().getSimpleName());){
            Loggers.MSG.info("New step service for type \"{}\"", (Object)stepType);
            super.doStart();
        }
    }

    @Override
    protected final void doStart() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("class_name", this.getClass().getSimpleName()).put("step_id", this.localLoadStep.loadStepId());){
            this.localLoadStep.start();
            Loggers.MSG.info("Step service for \"{}\" is started", (Object)this.localLoadStep.loadStepId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected void doStop() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("class_name", this.getClass().getSimpleName()).put("step_id", this.localLoadStep.loadStepId());){
            this.localLoadStep.stop();
            Loggers.MSG.info("Step service for \"{}\" is stopped", (Object)this.localLoadStep.loadStepId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected final void doClose() throws IOException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("class_name", this.getClass().getSimpleName()).put("step_id", this.localLoadStep.loadStepId());){
            super.doStop();
            this.localLoadStep.close();
            Loggers.MSG.info("Step service for \"{}\" is closed", (Object)this.localLoadStep.loadStepId());
        }
    }

    @Override
    public String name() {
        return "load/step/" + this.hashCode();
    }

    @Override
    public final String loadStepId() throws RemoteException {
        return this.localLoadStep.loadStepId();
    }

    @Override
    public long runId() throws RemoteException {
        return this.localLoadStep.runId();
    }

    @Override
    public final String getTypeName() throws RemoteException {
        return this.localLoadStep.getTypeName();
    }

    @Override
    public final List<? extends AllMetricsSnapshot> metricsSnapshots() throws RemoteException {
        return this.localLoadStep.metricsSnapshots();
    }

    @Override
    public final boolean await(long timeout, TimeUnit timeUnit) throws IllegalStateException, InterruptedException {
        CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("class_name", this.getClass().getSimpleName()).put("step_id", this.localLoadStep.loadStepId());
        try {
            boolean bl = this.localLoadStep.await(timeout, timeUnit);
            if (logCtx != null) {
                logCtx.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (logCtx != null) {
                    try {
                        logCtx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
    }
}

