/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="StepIdTriggeringPolicy", category="Core", printObject=true)
public final class StepIdTriggeringPolicy
extends AbstractTriggeringPolicy {
    private RollingFileManager manager;
    private String lastStepId = null;

    @PluginFactory
    public static StepIdTriggeringPolicy createPolicy() {
        return new StepIdTriggeringPolicy();
    }

    @Override
    public final void initialize(RollingFileManager manager) {
        this.manager = manager;
    }

    @Override
    public final boolean isTriggeringEvent(LogEvent logEvent) {
        String stepId = (String)logEvent.getContextData().getValue("step_id");
        if (null == stepId) {
            return false;
        }
        ThreadContext.put("step_id", stepId);
        if (stepId.equals(this.lastStepId)) {
            return false;
        }
        this.lastStepId = stepId;
        this.manager.getFileName();
        return true;
    }
}

