/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.logging.MetricsAsciiTableLogMessage;
import com.emc.mongoose.base.logging.MetricsCsvLogMessage;
import com.emc.mongoose.base.logging.StepResultsMetricsLogMessage;
import com.emc.mongoose.base.metrics.MetricsConstants;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.DistributedMetricsContext;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.DistributedAllMetricsSnapshot;
import com.emc.mongoose.base.metrics.util.PrometheusMetricsExporter;
import com.emc.mongoose.base.metrics.util.PrometheusMetricsExporterImpl;
import com.github.akurilov.fiber4j.ExclusiveFiberBase;
import com.github.akurilov.fiber4j.FibersExecutor;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class MetricsManagerImpl
extends ExclusiveFiberBase
implements MetricsManager {
    private static final String CLS_NAME = MetricsManagerImpl.class.getSimpleName();
    private final Set<MetricsContext> allMetrics = new ConcurrentSkipListSet<MetricsContext>();
    private final Map<DistributedMetricsContext, PrometheusMetricsExporter> distributedMetrics = new ConcurrentHashMap<DistributedMetricsContext, PrometheusMetricsExporter>();
    private final Set<MetricsContext> selectedMetrics = new TreeSet<MetricsContext>();
    private final Lock outputLock = new ReentrantLock();

    public MetricsManagerImpl(FibersExecutor instance) {
        super(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invokeTimedExclusively(long startTimeNanos) {
        ThreadContext.put("class_name", CLS_NAME);
        int actualConcurrency = 0;
        if (this.outputLock.tryLock()) {
            try {
                for (MetricsContext metricsCtx : this.allMetrics) {
                    int nextConcurrencyThreshold;
                    ThreadContext.put("step_id", metricsCtx.loadStepId());
                    metricsCtx.refreshLastSnapshot();
                    Object snapshot = metricsCtx.lastSnapshot();
                    if (snapshot == null) continue;
                    ConcurrencyMetricSnapshot concurrencySnapshot = snapshot.concurrencySnapshot();
                    if (concurrencySnapshot != null) {
                        actualConcurrency = (int)concurrencySnapshot.last();
                    }
                    if ((nextConcurrencyThreshold = metricsCtx.concurrencyThreshold()) > 0 && actualConcurrency >= nextConcurrencyThreshold) {
                        if (!metricsCtx.thresholdStateEntered() && !metricsCtx.thresholdStateExited()) {
                            Loggers.MSG.info("{}: the threshold of {} active load operations count is reached, starting the additional metrics accounting", (Object)metricsCtx.toString(), (Object)metricsCtx.concurrencyThreshold());
                            metricsCtx.enterThresholdState();
                        }
                    } else if (metricsCtx.thresholdStateEntered() && !metricsCtx.thresholdStateExited()) {
                        MetricsManagerImpl.exitMetricsThresholdState(metricsCtx);
                    }
                    long outputPeriodMillis = metricsCtx.outputPeriodMillis();
                    long lastOutputTs = metricsCtx.lastOutputTs();
                    long nextOutputTs = System.currentTimeMillis();
                    if (outputPeriodMillis <= 0L || nextOutputTs - lastOutputTs < outputPeriodMillis) continue;
                    metricsCtx.lastOutputTs(nextOutputTs);
                    this.selectedMetrics.add(metricsCtx);
                    if (!metricsCtx.avgPersistEnabled()) continue;
                    Loggers.METRICS_FILE.info(new MetricsCsvLogMessage((AllMetricsSnapshot)snapshot, metricsCtx.opType(), metricsCtx.concurrencyLimit()));
                }
                if (!this.selectedMetrics.isEmpty()) {
                    Loggers.METRICS_STD_OUT.info(new MetricsAsciiTableLogMessage(this.selectedMetrics));
                    this.selectedMetrics.clear();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (Throwable cause) {
                Exceptions.throwUncheckedIfInterrupted(cause);
                LogUtil.exception(Level.DEBUG, cause, "Metrics manager failure", new Object[0]);
            }
            finally {
                this.outputLock.unlock();
            }
        }
    }

    private void startIfNotStarted() {
        if (!this.isStarted()) {
            super.start();
            Loggers.MSG.debug("Started the metrics manager fiber");
        }
    }

    @Override
    public void register(MetricsContext metricsCtx) {
        try {
            this.startIfNotStarted();
            this.allMetrics.add(metricsCtx);
            if (metricsCtx instanceof DistributedMetricsContext) {
                DistributedMetricsContext distributedMetricsCtx = (DistributedMetricsContext)metricsCtx;
                String[] labelValues = new String[]{metricsCtx.loadStepId(), metricsCtx.opType().name(), String.valueOf(metricsCtx.concurrencyLimit()), metricsCtx.itemDataSize().toString(), "" + metricsCtx.startTimeStamp(), ((DistributedMetricsContext)metricsCtx).nodeAddrs().toString(), metricsCtx.comment(), String.valueOf(metricsCtx.runId())};
                this.distributedMetrics.put(distributedMetricsCtx, (PrometheusMetricsExporter)((Collector)((Object)new PrometheusMetricsExporterImpl(distributedMetricsCtx).labels(MetricsConstants.METRIC_LABELS, labelValues).quantiles((List)distributedMetricsCtx.quantileValues()))).register());
            }
            Loggers.MSG.debug("Metrics context \"{}\" registered", (Object)metricsCtx);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted(e);
            LogUtil.exception(Level.WARN, e, "Failed to register the Prometheus Exporter for the metrics context \"{}\"", metricsCtx.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void unregister(MetricsContext metricsCtx) {
        try {
            logCtx = CloseableThreadContext.put("step_id", metricsCtx.loadStepId()).put("class_name", this.getClass().getSimpleName());
            try {
                if (this.allMetrics.remove(metricsCtx)) {
                    try {
                        if (!this.outputLock.tryLock(10000000000L, TimeUnit.NANOSECONDS)) {
                            Loggers.ERR.warn("Acquire lock timeout while unregistering the metrics context \"{}\"", (Object)metricsCtx);
                        }
                        metricsCtx.refreshLastSnapshot();
                        snapshot = metricsCtx.lastSnapshot();
                        if (metricsCtx.thresholdStateEntered() && !metricsCtx.thresholdStateExited()) {
                            MetricsManagerImpl.exitMetricsThresholdState(metricsCtx);
                        }
                        if (snapshot != null && metricsCtx.sumPersistEnabled()) {
                            Loggers.METRICS_FILE_TOTAL.info(new MetricsCsvLogMessage((AllMetricsSnapshot)snapshot, metricsCtx.opType(), metricsCtx.concurrencyLimit()));
                        }
                        if (!(metricsCtx instanceof DistributedMetricsContext)) ** GOTO lbl33
                        distributedMetricsCtx = (DistributedMetricsContext)metricsCtx;
                        Loggers.METRICS_STD_OUT.info(new MetricsAsciiTableLogMessage(Collections.singleton(metricsCtx)));
                        aggregSnapshot = (DistributedAllMetricsSnapshot)snapshot;
                        if (aggregSnapshot != null) {
                            Loggers.METRICS_STD_OUT.info(new StepResultsMetricsLogMessage(metricsCtx.opType(), metricsCtx.loadStepId(), metricsCtx.concurrencyLimit(), aggregSnapshot));
                        }
                        if ((exporter = this.distributedMetrics.remove(distributedMetricsCtx)) == null) ** GOTO lbl33
                        CollectorRegistry.defaultRegistry.unregister((Collector)exporter);
                    }
                    catch (InterruptedException e) {
                        com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
                    }
                    finally {
                        try {
                            this.outputLock.unlock();
                        }
                        catch (IllegalMonitorStateException var3_6) {}
                    }
                } else {
                    Loggers.ERR.debug("Metrics context \"{}\" has not been registered", (Object)metricsCtx);
                }
lbl33:
                // 5 sources

                Loggers.MSG.debug("Metrics context \"{}\" unregistered", (Object)metricsCtx);
            }
            finally {
                if (logCtx != null) {
                    logCtx.close();
                }
            }
        }
        finally {
            if (this.allMetrics.size() == 0) {
                this.stop();
                Loggers.MSG.debug("Stopped the metrics manager fiber");
            }
        }
    }

    private static void exitMetricsThresholdState(MetricsContext metricsCtx) {
        Loggers.MSG.info("{}: the active load operations count is below the threshold of {}, stopping the additional metrics accounting", (Object)metricsCtx.toString(), (Object)metricsCtx.concurrencyThreshold());
        MetricsContext lastThresholdMetrics = metricsCtx.thresholdMetrics();
        Object snapshot = lastThresholdMetrics.lastSnapshot();
        if (lastThresholdMetrics.sumPersistEnabled()) {
            Loggers.METRICS_THRESHOLD_FILE_TOTAL.info(new MetricsCsvLogMessage((AllMetricsSnapshot)snapshot, metricsCtx.opType(), metricsCtx.concurrencyLimit()));
        }
        metricsCtx.exitThresholdState();
    }

    @Override
    protected final void doClose() {
        this.allMetrics.forEach(MetricsContext::close);
        this.allMetrics.clear();
        this.distributedMetrics.clear();
    }
}

