/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.context;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.github.akurilov.commons.system.SizeInBytes;
import java.util.Map;

public abstract class MetricsContextBase<S extends AllMetricsSnapshot>
implements MetricsContext<S> {
    protected final Map<String, Object> metadata;
    protected final long ts = System.nanoTime();
    protected final int concurrencyThreshold;
    protected final boolean stdOutColorFlag;
    protected final long outputPeriodMillis;
    private volatile long tsStart = -1L;
    private volatile long lastOutputTs = 0L;
    private volatile boolean thresholdStateExitedFlag = false;
    protected volatile MetricsContextBase thresholdMetricsCtx = null;
    protected volatile S lastSnapshot = null;

    protected MetricsContextBase(Map metadata, int concurrencyThreshold, boolean stdOutColorFlag, long outputPeriodMillis) {
        this.metadata = metadata;
        this.concurrencyThreshold = concurrencyThreshold > 0 ? concurrencyThreshold : Integer.MAX_VALUE;
        this.stdOutColorFlag = stdOutColorFlag;
        this.outputPeriodMillis = outputPeriodMillis;
    }

    @Override
    public void start() {
        this.tsStart = System.currentTimeMillis();
        this.metadata.put("start_time", this.tsStart);
    }

    @Override
    public final boolean isStarted() {
        return this.tsStart > -1L;
    }

    @Override
    public final long startTimeStamp() {
        return this.tsStart;
    }

    @Override
    public final Map metadata() {
        return this.metadata;
    }

    @Override
    public final String loadStepId() {
        return (String)this.metadata.get("load_step_id");
    }

    @Override
    public final long runId() {
        return (Long)this.metadata.get("run_id");
    }

    @Override
    public final OpType opType() {
        return (OpType)((Object)this.metadata.get("load_op_type"));
    }

    @Override
    public final int concurrencyLimit() {
        return (Integer)this.metadata.get("storage_driver_limit_concurrency");
    }

    @Override
    public final int concurrencyThreshold() {
        return this.concurrencyThreshold;
    }

    @Override
    public final SizeInBytes itemDataSize() {
        return (SizeInBytes)this.metadata.get("item_data_size");
    }

    @Override
    public final boolean stdOutColorEnabled() {
        return this.stdOutColorFlag;
    }

    @Override
    public final long outputPeriodMillis() {
        return this.outputPeriodMillis;
    }

    @Override
    public final long lastOutputTs() {
        return this.lastOutputTs;
    }

    @Override
    public final void lastOutputTs(long ts) {
        this.lastOutputTs = ts;
    }

    @Override
    public final S lastSnapshot() {
        if (this.lastSnapshot == null) {
            this.refreshLastSnapshot();
        }
        return this.lastSnapshot;
    }

    @Override
    public void refreshLastSnapshot() {
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.refreshLastSnapshot();
        }
    }

    @Override
    public final MetricsContext thresholdMetrics() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Nested metrics context is not exist");
        }
        return this.thresholdMetricsCtx;
    }

    @Override
    public final void enterThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx != null) {
            throw new IllegalStateException("Nested metrics context already exists");
        }
        this.thresholdMetricsCtx = this.newThresholdMetricsContext();
        this.thresholdMetricsCtx.start();
    }

    protected abstract MetricsContextBase<S> newThresholdMetricsContext();

    @Override
    public final boolean thresholdStateEntered() {
        return this.thresholdMetricsCtx != null && this.thresholdMetricsCtx.isStarted();
    }

    @Override
    public final void exitThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Threshold state was not entered");
        }
        this.thresholdMetricsCtx.close();
        this.thresholdStateExitedFlag = true;
    }

    @Override
    public final boolean thresholdStateExited() {
        return this.thresholdStateExitedFlag;
    }

    public final int hashCode() {
        return (int)this.ts;
    }

    @Override
    public final int compareTo(MetricsContext<S> other) {
        return Long.compare(this.hashCode(), other.hashCode());
    }

    @Override
    public void close() {
        this.tsStart = -1L;
        this.lastSnapshot = null;
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.close();
            this.thresholdMetricsCtx = null;
        }
    }

    @Override
    public long elapsedTimeMillis() {
        return System.currentTimeMillis() - this.tsStart;
    }

    @Override
    public String comment() {
        return (String)this.metadata.get("user_comment");
    }
}

