/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.context;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.metrics.context.ContextBuilder;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.context.MetricsContextBase;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import com.emc.mongoose.base.metrics.type.ConcurrencyMeterImpl;
import com.emc.mongoose.base.metrics.type.HistogramImpl;
import com.emc.mongoose.base.metrics.type.LongMeter;
import com.emc.mongoose.base.metrics.type.RateMeter;
import com.emc.mongoose.base.metrics.type.RateMeterImpl;
import com.emc.mongoose.base.metrics.type.TimingMeterImpl;
import com.emc.mongoose.base.metrics.util.ConcurrentSlidingWindowLongReservoir;
import com.github.akurilov.commons.system.SizeInBytes;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;

public class MetricsContextImpl<S extends AllMetricsSnapshotImpl>
extends MetricsContextBase<S>
implements MetricsContext<S> {
    private final LongMeter<TimingMetricSnapshot> reqDuration;
    private final LongMeter<TimingMetricSnapshot> respLatency = new TimingMeterImpl(new HistogramImpl(new ConcurrentSlidingWindowLongReservoir(1028)), "latency");
    private final LongMeter<ConcurrencyMetricSnapshot> actualConcurrency;
    private final RateMeter<RateMetricSnapshot> throughputSuccess;
    private final RateMeter<RateMetricSnapshot> throughputFail;
    private final RateMeter<RateMetricSnapshot> reqBytes;
    private volatile TimingMetricSnapshot reqDurSnapshot;
    private volatile TimingMetricSnapshot respLatSnapshot = this.respLatency.snapshot();
    private volatile ConcurrencyMetricSnapshot actualConcurrencySnapshot;
    private volatile long lastSnapshotsUpdateTs = 0L;
    private final IntSupplier actualConcurrencyGauge;

    public MetricsContextImpl(Map<String, Object> metadata, IntSupplier actualConcurrencyGauge, int concurrencyThreshold, int updateIntervalSec, boolean stdOutColorFlag) {
        super(metadata, concurrencyThreshold, stdOutColorFlag, TimeUnit.SECONDS.toMillis(updateIntervalSec));
        this.reqDuration = new TimingMeterImpl(new HistogramImpl(new ConcurrentSlidingWindowLongReservoir(1028)), "duration");
        this.reqDurSnapshot = this.reqDuration.snapshot();
        this.actualConcurrencyGauge = actualConcurrencyGauge;
        this.actualConcurrency = new ConcurrencyMeterImpl("concurrency");
        this.actualConcurrencySnapshot = this.actualConcurrency.snapshot();
        Clock clock = Clock.systemUTC();
        this.throughputSuccess = new RateMeterImpl(clock, "success_op");
        this.throughputFail = new RateMeterImpl(clock, "failed_op");
        this.reqBytes = new RateMeterImpl(clock, "byte");
    }

    @Override
    public final void start() {
        super.start();
        this.throughputSuccess.resetStartTime();
        this.throughputFail.resetStartTime();
        this.reqBytes.resetStartTime();
    }

    @Override
    public final void markSucc(long bytes, long duration, long latency) {
        this.throughputSuccess.update(1L);
        this.reqBytes.update(bytes);
        this.updateTimings(latency, duration);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(bytes, duration, latency);
        }
    }

    @Override
    public final void markPartSucc(long bytes, long duration, long latency) {
        this.reqBytes.update(bytes);
        this.updateTimings(latency, duration);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(bytes, duration, latency);
        }
    }

    @Override
    public final void markSucc(long count, long bytes, long[] durationValues, long[] latencyValues) {
        this.throughputSuccess.update(count);
        this.reqBytes.update(bytes);
        int timingsLen = Math.min(durationValues.length, latencyValues.length);
        for (int i = 0; i < timingsLen; ++i) {
            long duration = durationValues[i];
            long latency = latencyValues[i];
            this.updateTimings(latency, duration);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(count, bytes, durationValues, latencyValues);
        }
    }

    @Override
    public final void markPartSucc(long bytes, long[] durationValues, long[] latencyValues) {
        this.reqBytes.update(bytes);
        int timingsLen = Math.min(durationValues.length, latencyValues.length);
        for (int i = 0; i < timingsLen; ++i) {
            long duration = durationValues[i];
            long latency = latencyValues[i];
            this.updateTimings(latency, duration);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(bytes, durationValues, latencyValues);
        }
    }

    private void updateTimings(long latencyMicros, long durationMicros) {
        if (latencyMicros > 0L && durationMicros > latencyMicros) {
            this.reqDuration.update(durationMicros);
            this.respLatency.update(latencyMicros);
        }
    }

    @Override
    public final void markFail() {
        this.throughputFail.update(1L);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail();
        }
    }

    @Override
    public final void markFail(long count) {
        this.throughputFail.update(count);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail(count);
        }
    }

    @Override
    public final boolean avgPersistEnabled() {
        return false;
    }

    @Override
    public final boolean sumPersistEnabled() {
        return false;
    }

    @Override
    public void refreshLastSnapshot() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastSnapshotsUpdateTs > 100L) {
            this.lastSnapshotsUpdateTs = currentTimeMillis;
            this.updateTimingSnapshots();
            this.actualConcurrency.update(this.actualConcurrencyGauge.getAsInt());
            this.actualConcurrencySnapshot = this.actualConcurrency.snapshot();
        }
        this.lastSnapshot = new AllMetricsSnapshotImpl(this.reqDurSnapshot, this.respLatSnapshot, this.actualConcurrencySnapshot, (RateMetricSnapshot)this.throughputFail.snapshot(), (RateMetricSnapshot)this.throughputSuccess.snapshot(), (RateMetricSnapshot)this.reqBytes.snapshot(), this.elapsedTimeMillis());
        super.refreshLastSnapshot();
    }

    private void updateTimingSnapshots() {
        this.reqDurSnapshot = this.reqDuration.snapshot();
        this.respLatSnapshot = this.respLatency.snapshot();
    }

    @Override
    protected MetricsContextImpl<S> newThresholdMetricsContext() {
        return new ContextBuilderImpl().loadStepId(this.loadStepId()).opType(this.opType()).actualConcurrencyGauge(this.actualConcurrencyGauge).concurrencyLimit(this.concurrencyLimit()).concurrencyThreshold(0).itemDataSize(this.itemDataSize()).outputPeriodSec((int)TimeUnit.MILLISECONDS.toSeconds(this.outputPeriodMillis)).stdOutColorFlag(this.stdOutColorFlag).runId(this.runId()).build();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof MetricsContextImpl) {
            return 0 == this.compareTo((MetricsContextImpl)other);
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.opType().name() + "-" + this.concurrencyLimit() + "x1@" + this.loadStepId() + ")";
    }

    @Override
    public final void close() {
        super.close();
    }

    public static ContextBuilder builder() {
        return new ContextBuilderImpl();
    }

    private static class ContextBuilderImpl
    implements ContextBuilder<ContextBuilder, MetricsContextImpl> {
        private IntSupplier actualConcurrencyGauge;
        private int concurrencyThreshold;
        private boolean stdOutColorFlag;
        private int outputPeriodSec;
        private Map<String, Object> metadata = new HashMap<String, Object>();

        private ContextBuilderImpl() {
        }

        @Override
        public MetricsContextImpl build() {
            return new MetricsContextImpl(this.metadata, this.actualConcurrencyGauge, this.concurrencyThreshold, this.outputPeriodSec, this.stdOutColorFlag);
        }

        @Override
        public ContextBuilderImpl loadStepId(String id) {
            this.metadata.put("load_step_id", id);
            return this;
        }

        @Override
        public ContextBuilderImpl runId(long id) {
            this.metadata.put("run_id", id);
            return this;
        }

        @Override
        public ContextBuilder comment(String comment) {
            this.metadata.put("user_comment", comment);
            return this;
        }

        @Override
        public ContextBuilderImpl opType(OpType opType) {
            this.metadata.put("load_op_type", (Object)opType);
            return this;
        }

        @Override
        public ContextBuilderImpl concurrencyLimit(int concurrencyLimit) {
            this.metadata.put("storage_driver_limit_concurrency", concurrencyLimit);
            return this;
        }

        @Override
        public ContextBuilderImpl concurrencyThreshold(int concurrencyThreshold) {
            this.concurrencyThreshold = concurrencyThreshold;
            return this;
        }

        @Override
        public ContextBuilderImpl itemDataSize(SizeInBytes itemDataSize) {
            this.metadata.put("item_data_size", itemDataSize);
            return this;
        }

        @Override
        public ContextBuilderImpl stdOutColorFlag(boolean stdOutColorFlag) {
            this.stdOutColorFlag = stdOutColorFlag;
            return this;
        }

        @Override
        public ContextBuilderImpl outputPeriodSec(int outputPeriodSec) {
            this.outputPeriodSec = outputPeriodSec;
            return this;
        }

        @Override
        public ContextBuilderImpl actualConcurrencyGauge(IntSupplier actualConcurrencyGauge) {
            this.actualConcurrencyGauge = actualConcurrencyGauge;
            return this;
        }
    }
}

