/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.snapshot;

import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.NamedMetricSnapshotBase;
import java.util.List;

public class ConcurrencyMetricSnapshotImpl
extends NamedMetricSnapshotBase
implements ConcurrencyMetricSnapshot {
    private final long last;
    private final double mean;

    public ConcurrencyMetricSnapshotImpl(String name, long last, double mean) {
        super(name);
        this.last = last;
        this.mean = mean;
    }

    public static ConcurrencyMetricSnapshot aggregate(List<ConcurrencyMetricSnapshot> snapshots) {
        int snapshotsCount = snapshots.size();
        if (snapshotsCount == 1) {
            return snapshots.get(0);
        }
        long lastSum = 0L;
        double meanSum = 0.0;
        for (int i = 0; i < snapshotsCount; ++i) {
            ConcurrencyMetricSnapshot nextSnapshot = snapshots.get(i);
            lastSum += nextSnapshot.last();
            meanSum += nextSnapshot.mean();
        }
        return new ConcurrencyMetricSnapshotImpl(snapshots.get(0).name(), lastSum, meanSum);
    }

    @Override
    public final long last() {
        return this.last;
    }

    @Override
    public final double mean() {
        return this.mean;
    }
}

