/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.snapshot;

import com.emc.mongoose.base.metrics.snapshot.HistogramSnapshot;
import java.util.Arrays;
import java.util.List;

public class HistogramSnapshotImpl
implements HistogramSnapshot {
    private static final HistogramSnapshotImpl EMPTY = new HistogramSnapshotImpl(new long[0]);
    private final long[] sortedVals;

    public HistogramSnapshotImpl(long[] vals) {
        this.sortedVals = vals;
        Arrays.sort(this.sortedVals);
    }

    public static HistogramSnapshot aggregate(List<HistogramSnapshot> snapshots) {
        if (0 == snapshots.size()) {
            return EMPTY;
        }
        if (1 == snapshots.size()) {
            return snapshots.get(0);
        }
        int sizeSum = 0;
        for (int i = 0; i < snapshots.size(); ++i) {
            sizeSum += snapshots.get(i).values().length;
        }
        long[] valuesToAggregate = new long[sizeSum];
        int k = 0;
        for (int i = 0; i < snapshots.size(); ++i) {
            long[] values = snapshots.get(i).values();
            for (int j = 0; j < values.length; ++j) {
                valuesToAggregate[k] = values[j];
                ++k;
            }
        }
        return new HistogramSnapshotImpl(valuesToAggregate);
    }

    @Override
    public long quantile(double quantile) {
        if (0 == this.sortedVals.length) {
            return 0L;
        }
        if (quantile >= 0.0 || quantile < 1.0) {
            return this.sortedVals[(int)(quantile * (double)this.sortedVals.length)];
        }
        throw new IllegalArgumentException(quantile + " is not in range [0..1)");
    }

    @Override
    public final long[] values() {
        return this.sortedVals;
    }

    @Override
    public long last() {
        return this.sortedVals[this.sortedVals.length - 1];
    }
}

