/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.snapshot;

import com.emc.mongoose.base.metrics.snapshot.HistogramSnapshot;
import com.emc.mongoose.base.metrics.snapshot.HistogramSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.NamedCountMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import java.util.ArrayList;
import java.util.List;

public class TimingMetricSnapshotImpl
extends NamedCountMetricSnapshotImpl
implements TimingMetricSnapshot {
    private final long sum;
    private final long min;
    private final long max;
    private final double mean;
    private final HistogramSnapshot histogramSnapshot;

    public TimingMetricSnapshotImpl(long sum, long count, long min, long max, double mean, HistogramSnapshot histogramSnapshot, String metricName) {
        super(metricName, count);
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.histogramSnapshot = histogramSnapshot;
    }

    public static TimingMetricSnapshot aggregate(List<TimingMetricSnapshot> snapshots) {
        int snapshotCount = snapshots.size();
        if (snapshotCount == 1) {
            return snapshots.get(0);
        }
        long countSum = 0L;
        long sumOfSums = 0L;
        long newMax = Long.MIN_VALUE;
        long newMin = Long.MAX_VALUE;
        ArrayList<HistogramSnapshot> histogramSnapshots = new ArrayList<HistogramSnapshot>(snapshotCount);
        for (int i = 0; i < snapshotCount; ++i) {
            TimingMetricSnapshot nextSnapshot = snapshots.get(i);
            countSum += nextSnapshot.count();
            sumOfSums += nextSnapshot.sum();
            newMax = Math.max(newMax, nextSnapshot.max());
            newMin = Math.min(newMin, nextSnapshot.min());
            histogramSnapshots.add(nextSnapshot.histogramSnapshot());
        }
        if (sumOfSums == 0L) {
            newMin = 0L;
            newMax = 0L;
        }
        double newMean = countSum > 0L ? (double)sumOfSums / (double)countSum : 0.0;
        return new TimingMetricSnapshotImpl(sumOfSums, countSum, newMin, newMax, newMean, HistogramSnapshotImpl.aggregate(histogramSnapshots), snapshots.get(0).name());
    }

    @Override
    public final long sum() {
        return this.sum;
    }

    @Override
    public final long min() {
        return this.min;
    }

    @Override
    public final long max() {
        return this.max;
    }

    @Override
    public long quantile(double value) {
        return this.histogramSnapshot.quantile(value);
    }

    @Override
    public final HistogramSnapshot histogramSnapshot() {
        return this.histogramSnapshot;
    }

    @Override
    public final double mean() {
        return this.mean;
    }
}

