/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.type;

import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.type.LongMeter;
import java.util.concurrent.atomic.LongAdder;

public class ConcurrencyMeterImpl
implements LongMeter<ConcurrencyMetricSnapshot> {
    private final String name;
    private final LongAdder counter = new LongAdder();
    private final LongAdder sumAdder = new LongAdder();
    private volatile long last = 0L;

    public ConcurrencyMeterImpl(String name) {
        this.name = name;
    }

    @Override
    public final void update(long v) {
        this.counter.increment();
        this.sumAdder.add(v);
        this.last = v;
    }

    @Override
    public final ConcurrencyMetricSnapshotImpl snapshot() {
        long count = this.counter.sum();
        double mean = count > 0L ? (double)this.sumAdder.sum() / (double)count : 0.0;
        return new ConcurrencyMetricSnapshotImpl(this.name, this.last, mean);
    }
}

