/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.type;

import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.type.EWMA;
import com.emc.mongoose.base.metrics.type.LoadAverage;
import com.emc.mongoose.base.metrics.type.RateMeter;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class RateMeterImpl
implements RateMeter<RateMetricSnapshot> {
    private static final long TICK_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final String metricName;
    private final LoadAverage rateAvg;
    private final LongAdder count = new LongAdder();
    private final Clock clock;
    private final AtomicLong lastTick = new AtomicLong();
    private long startTimeMillis;

    public RateMeterImpl(Clock clock, String name) {
        this(clock, 1, name);
    }

    protected RateMeterImpl(Clock clock, int period, String name) throws IllegalArgumentException {
        if (period <= 0) {
            throw new IllegalArgumentException("Period should be more than 0 [s]");
        }
        boolean interval = true;
        this.rateAvg = new EWMA(1.0 - Math.exp(-1.0 / (double)period), 1L, TimeUnit.SECONDS);
        this.clock = clock;
        this.resetStartTime();
        this.metricName = name;
    }

    @Override
    public void resetStartTime() {
        this.startTimeMillis = this.clock.millis();
        this.lastTick.set(this.startTimeMillis);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.millis();
        long ageMillis = newTick - oldTick;
        if (ageMillis > TICK_INTERVAL_MILLIS && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - ageMillis % TICK_INTERVAL_MILLIS)) {
            long requiredTicks = ageMillis / TICK_INTERVAL_MILLIS;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.rateAvg.tick();
            }
        }
    }

    @Override
    public void update(long v) {
        this.tickIfNecessary();
        this.count.add(v);
        this.rateAvg.update(v);
    }

    @Override
    public RateMetricSnapshotImpl snapshot() {
        return new RateMetricSnapshotImpl(this.lastRate(), this.meanRate(), this.metricName, this.count.sum(), this.elapsedTimeMillis());
    }

    long elapsedTimeMillis() {
        return this.clock.millis() - this.startTimeMillis;
    }

    double meanRate() {
        if (this.count.sum() == 0L) {
            return 0.0;
        }
        double elapsed = TimeUnit.MILLISECONDS.toSeconds(this.clock.millis() - this.startTimeMillis);
        return elapsed == 0.0 ? 0.0 : (double)this.count.sum() / elapsed;
    }

    double lastRate() {
        this.tickIfNecessary();
        return this.rateAvg.rate(TimeUnit.SECONDS);
    }
}

