/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.util;

import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.context.DistributedMetricsContext;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.HistogramSnapshot;
import com.emc.mongoose.base.metrics.snapshot.NamedMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import com.emc.mongoose.base.metrics.util.PrometheusMetricsExporter;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PrometheusMetricsExporterImpl
extends Collector
implements PrometheusMetricsExporter {
    private final List<String> labelValues = new ArrayList<String>();
    private final List<String> labelNames = new ArrayList<String>();
    private final DistributedMetricsContext metricsContext;
    private final List<Double> quantileValues = new ArrayList<Double>();
    private String help = "";

    public PrometheusMetricsExporterImpl(DistributedMetricsContext context) {
        this.metricsContext = context;
    }

    @Override
    public PrometheusMetricsExporterImpl quantile(double value) {
        if (!(value < 1.0) || !(value >= 0.0)) {
            throw new IllegalArgumentException("Invalid quantiele value : " + value);
        }
        this.quantileValues.add(value);
        return this;
    }

    @Override
    public PrometheusMetricsExporterImpl quantiles(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.quantile(values[i]);
        }
        return this;
    }

    @Override
    public PrometheusMetricsExporterImpl quantiles(List<Double> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.quantile(values.get(i));
        }
        return this;
    }

    @Override
    public PrometheusMetricsExporterImpl label(String name, String value) {
        this.labelNames.add(name);
        this.labelValues.add(value);
        return this;
    }

    @Override
    public PrometheusMetricsExporterImpl labels(String[] names, String[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("The number of label names(" + names.length + ") does not match the number of values(" + values.length + ")");
        }
        this.labelNames.addAll(Arrays.asList(names));
        this.labelValues.addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public PrometheusMetricsExporterImpl help(String helpInfo) {
        this.help = helpInfo;
        return this;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        AllMetricsSnapshot snapshot = this.metricsContext.lastSnapshot();
        if (snapshot != null) {
            this.collectSnapshot(snapshot.durationSnapshot(), mfsList);
            this.collectSnapshot(snapshot.latencySnapshot(), mfsList);
            this.collectSnapshot(snapshot.concurrencySnapshot(), mfsList);
            this.collectSnapshot(snapshot.byteSnapshot(), mfsList);
            this.collectSnapshot(snapshot.successSnapshot(), mfsList);
            this.collectSnapshot(snapshot.failsSnapshot(), mfsList);
            this.collectElapsedTime(snapshot.elapsedTimeMillis(), mfsList);
        }
        return mfsList;
    }

    private void collectElapsedTime(double timeMillis, List<Collector.MetricFamilySamples> mfsList) {
        mfsList.add(new Collector.MetricFamilySamples(String.format("mongoose_%s", "elapsed_time" + System.currentTimeMillis()), Collector.Type.GAUGE, this.help, Collections.singletonList(this.newSample("elapsed_time", "value", timeMillis / 1000.0))));
    }

    private void collectSnapshot(NamedMetricSnapshot snapshot, List<Collector.MetricFamilySamples> mfsList) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        if (snapshot instanceof TimingMetricSnapshot) {
            samples.addAll(this.collect((TimingMetricSnapshot)snapshot));
        } else if (snapshot instanceof RateMetricSnapshot) {
            samples.addAll(this.collect((RateMetricSnapshot)snapshot));
        } else if (snapshot instanceof ConcurrencyMetricSnapshot) {
            samples.addAll(this.collect((ConcurrencyMetricSnapshot)snapshot));
        } else {
            Loggers.ERR.warn("Unexpected metric snapshot type: {}", (Object)snapshot.getClass());
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(String.format("mongoose_%s", snapshot.name() + snapshot.hashCode()), Collector.Type.GAUGE, this.help, samples);
        mfsList.add(mfs);
    }

    private List<Collector.MetricFamilySamples.Sample> collect(RateMetricSnapshot metric) {
        String metricName = metric.name();
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(this.newSample(metricName, "count", metric.count()));
        samples.add(this.newSample(metricName, "rate_mean", metric.mean()));
        samples.add(this.newSample(metricName, "rate_last", metric.last()));
        return samples;
    }

    private List<Collector.MetricFamilySamples.Sample> collect(TimingMetricSnapshot metric) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        HistogramSnapshot snapshot = metric.histogramSnapshot();
        String metricName = metric.name();
        samples.add(this.newSample(metricName, "count", metric.count()));
        samples.add(this.newSample(metricName, "sum", (double)metric.sum() / 1000000.0));
        samples.add(this.newSample(metricName, "mean", metric.mean() / 1000000.0));
        samples.add(this.newSample(metricName, "min", (double)metric.min() / 1000000.0));
        for (int i = 0; i < this.quantileValues.size(); ++i) {
            samples.add(this.newSample(metricName, "quantile_" + this.quantileValues.get(i).toString().replaceAll("\\.", "_"), (double)snapshot.quantile(this.quantileValues.get(i)) / 1000000.0));
        }
        samples.add(this.newSample(metricName, "max", (double)metric.max() / 1000000.0));
        return samples;
    }

    private List<Collector.MetricFamilySamples.Sample> collect(ConcurrencyMetricSnapshot metric) {
        String metricName = metric.name();
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(this.newSample(metricName, "mean", metric.mean()));
        samples.add(this.newSample(metricName, "last", metric.last()));
        return samples;
    }

    private Collector.MetricFamilySamples.Sample newSample(String metricName, String aggregationType, double value) {
        return new Collector.MetricFamilySamples.Sample(String.format("mongoose_%s", metricName) + "_" + aggregationType, this.labelNames, this.labelValues, value);
    }
}

