/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.storage.driver;

import com.emc.mongoose.base.concurrent.Daemon;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.driver.StorageDriverFactory;
import com.github.akurilov.commons.concurrent.AsyncRunnable;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.CloseableThreadContext;

public interface StorageDriver<I extends Item, O extends Operation<I>>
extends Daemon,
Output<O> {
    public static final int BUFF_SIZE_MIN = 4096;
    public static final int BUFF_SIZE_MAX = 0x1000000;

    public void operationResultOutput(Output<O> var1);

    public List<I> list(ItemFactory<I> var1, String var2, String var3, int var4, I var5, int var6) throws IOException;

    @Override
    public boolean put(O var1);

    @Override
    public int put(List<O> var1, int var2, int var3);

    @Override
    public int put(List<O> var1);

    public int concurrencyLimit();

    public int activeOpCount();

    public long scheduledOpCount();

    public long completedOpCount();

    public boolean isIdle();

    public void adjustIoBuffers(long var1, OpType var3);

    @Override
    public AsyncRunnable stop();

    @Override
    public void close() throws IOException;

    public static <I extends Item, O extends Operation<I>, T extends StorageDriver<I, O>> T instance(List<Extension> extensions, Config storageConfig, DataInput dataInput, boolean verifyFlag, int batchSize, String stepId) throws IllegalArgumentException, InterruptedException, IllegalConfigurationException {
        try (CloseableThreadContext.Instance ctx = CloseableThreadContext.put("step_id", stepId).put("class_name", StorageDriver.class.getSimpleName());){
            if (storageConfig == null) {
                throw new IllegalArgumentException("Null storage config");
            }
            List factories = extensions.stream().filter(ext -> ext instanceof StorageDriverFactory).map(factory -> (StorageDriverFactory)factory).collect(Collectors.toList());
            String driverType = storageConfig.stringVal("driver-type");
            StorageDriverFactory selectedFactory = factories.stream().filter(factory -> driverType.equals(factory.id())).findFirst().orElseThrow(() -> new IllegalConfigurationException("Failed to create the storage driver for the type \"" + driverType + "\", available types: " + Arrays.toString(factories.stream().map(Extension::id).toArray())));
            Loggers.MSG.info("{}: creating the storage driver instance for the type \"{}\"", (Object)stepId, (Object)driverType);
            Object t = selectedFactory.create(stepId, dataInput, storageConfig, verifyFlag, batchSize);
            return t;
        }
    }
}

