/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.storage.driver;

import com.emc.mongoose.base.concurrent.DaemonBase;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.concurrent.ThreadUtil;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.logging.log4j.CloseableThreadContext;

public abstract class StorageDriverBase<I extends Item, O extends Operation<I>>
extends DaemonBase
implements StorageDriver<I, O> {
    private final DataInput itemDataInput;
    protected final String stepId;
    private Output<O> opResultOut = null;
    protected final int concurrencyLimit;
    protected final int ioWorkerCount;
    protected final String namespace;
    protected final Credential credential;
    protected final boolean verifyFlag;
    protected final ConcurrentMap<String, Credential> pathToCredMap = new ConcurrentHashMap<String, Credential>(1);
    private final ConcurrentMap<String, String> pathMap = new ConcurrentHashMap<String, String>(1);
    protected Function<String, String> requestNewPathFunc = this::requestNewPath;
    protected final ConcurrentMap<Credential, String> authTokens = new ConcurrentHashMap<Credential, String>(1);
    protected Function<Credential, String> requestAuthTokenFunc = this::requestNewAuthToken;

    protected StorageDriverBase(String stepId, DataInput itemDataInput, Config storageConfig, boolean verifyFlag) throws IllegalConfigurationException {
        this.itemDataInput = itemDataInput;
        Config driverConfig = storageConfig.configVal("driver");
        Config limitConfig = driverConfig.configVal("limit");
        this.stepId = stepId;
        this.namespace = storageConfig.stringVal("namespace");
        Config authConfig = storageConfig.configVal("auth");
        this.credential = Credential.getInstance(authConfig.stringVal("uid"), authConfig.stringVal("secret"));
        String authToken = authConfig.stringVal("token");
        if (authToken != null) {
            if (this.credential == null) {
                this.authTokens.put(Credential.NONE, authToken);
            } else {
                this.authTokens.put(this.credential, authToken);
            }
        }
        this.concurrencyLimit = limitConfig.intVal("concurrency");
        this.verifyFlag = verifyFlag;
        int confWorkerCount = driverConfig.intVal("threads");
        this.ioWorkerCount = confWorkerCount > 0 ? confWorkerCount : (this.concurrencyLimit > 0 ? Math.min(this.concurrencyLimit, ThreadUtil.getHardwareThreadCount()) : ThreadUtil.getHardwareThreadCount());
    }

    @Override
    public final void operationResultOutput(Output<O> opResultOut) {
        this.opResultOut = opResultOut;
    }

    protected abstract String requestNewPath(String var1);

    protected abstract String requestNewAuthToken(Credential var1);

    protected boolean prepare(O op) {
        op.reset();
        if (op instanceof DataOperation) {
            ((DataOperation)op).item().dataInput(this.itemDataInput);
        }
        String dstPath = op.dstPath();
        Credential credential = op.credential();
        if (credential != null) {
            this.pathToCredMap.putIfAbsent(dstPath == null ? "" : dstPath, credential);
            if (this.requestAuthTokenFunc != null) {
                this.authTokens.computeIfAbsent(credential, this.requestAuthTokenFunc);
            }
        }
        if (this.requestNewPathFunc != null && dstPath != null && !dstPath.isEmpty() && null == this.pathMap.computeIfAbsent(dstPath, this.requestNewPathFunc)) {
            Loggers.ERR.debug("Failed to compute the destination path for the operation: {}", (Object)op);
            op.status(Operation.Status.FAIL_UNKNOWN);
        }
        return true;
    }

    protected boolean handleCompleted(O op) {
        Object opResult;
        if (this.isStopped()) {
            return false;
        }
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("{}: Load operation completed", (Object)op);
        }
        if (this.opResultOut.put(opResult = op.result())) {
            return true;
        }
        Loggers.ERR.error("{}: Load operations results queue overflow, dropping the result", (Object)this.toString());
        return false;
    }

    @Override
    public final int concurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Override
    public Input<O> getInput() {
        throw new AssertionError((Object)"Shouldn't be invoked");
    }

    @Override
    protected void doClose() throws IOException, IllegalStateException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.stepId).put("class_name", StorageDriverBase.class.getSimpleName());){
            this.itemDataInput.close();
            this.authTokens.clear();
            this.pathToCredMap.clear();
            this.pathMap.clear();
            super.doClose();
            Loggers.MSG.debug("{}: closed", (Object)this.toString());
        }
        this.opResultOut = null;
    }

    public String toString() {
        return "storage/driver/" + this.concurrencyLimit + "/%s/" + this.hashCode();
    }
}

