/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.storage.driver.mock;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.confuse.Config;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class DummyStorageDriverMock<I extends Item, O extends Operation<I>>
extends AsyncRunnableBase
implements StorageDriver<I, O> {
    private final int concurrencyLimit;
    private final LongAdder scheduledOpCount = new LongAdder();
    private final LongAdder completedOpCount = new LongAdder();
    private Output<O> opResultOut = null;

    public DummyStorageDriverMock(Config storageConfig) {
        Config limitConfig = storageConfig.configVal("driver-limit");
        this.concurrencyLimit = limitConfig.intVal("concurrency");
    }

    @Override
    public final boolean put(O task) {
        if (!this.isStarted()) {
            Exceptions.throwUnchecked(new EOFException());
        }
        this.checkStateFor(task);
        if (this.opResultOut.put(task)) {
            this.scheduledOpCount.increment();
            this.completedOpCount.increment();
            return true;
        }
        return false;
    }

    @Override
    public final int put(List<O> tasks, int from, int to) {
        int i;
        if (!this.isStarted()) {
            Exceptions.throwUnchecked(new EOFException());
        }
        for (i = from; i < to && this.isStarted(); ++i) {
            Operation nextTask = (Operation)tasks.get(i);
            this.checkStateFor(nextTask);
            if (!this.opResultOut.put((Operation)tasks.get(i))) break;
        }
        int n = i - from;
        this.scheduledOpCount.add(n);
        this.completedOpCount.add(n);
        return n;
    }

    @Override
    public final int put(List<O> tasks) {
        if (!this.isStarted()) {
            Exceptions.throwUnchecked(new EOFException());
        }
        int n = 0;
        for (Operation nextOp : tasks) {
            if (!this.isStarted()) break;
            this.checkStateFor(nextOp);
            if (!this.opResultOut.put(nextOp)) break;
            ++n;
        }
        this.scheduledOpCount.add(n);
        this.completedOpCount.add(n);
        return n;
    }

    @Override
    public final Input<O> getInput() {
        throw new AssertionError();
    }

    private void checkStateFor(O op) {
        op.reset();
        op.startRequest();
        op.finishRequest();
        op.startResponse();
        if (op instanceof DataOperation) {
            DataOperation dataOp = (DataOperation)op;
            Item dataItem = dataOp.item();
            switch (dataOp.type()) {
                case CREATE: {
                    try {
                        dataOp.countBytesDone(dataItem.size());
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case READ: {
                    dataOp.startDataResponse();
                }
                case UPDATE: {
                    List<Range> fixedRanges = dataOp.fixedRanges();
                    if (fixedRanges == null || fixedRanges.isEmpty()) {
                        if (dataOp.hasMarkedRanges()) {
                            dataOp.countBytesDone(dataOp.markedRangesSize());
                            break;
                        }
                        try {
                            dataOp.countBytesDone(dataItem.size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    dataOp.countBytesDone(dataOp.markedRangesSize());
                    break;
                }
            }
            dataOp.startDataResponse();
        }
        op.finishResponse();
        op.status(Operation.Status.SUCC);
    }

    @Override
    public final void operationResultOutput(Output<O> opResultOut) {
        this.opResultOut = opResultOut;
    }

    @Override
    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public final int concurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Override
    public final int activeOpCount() {
        return (int)(this.scheduledOpCount() - this.completedOpCount());
    }

    @Override
    public final long scheduledOpCount() {
        return this.scheduledOpCount.sum();
    }

    @Override
    public final long completedOpCount() {
        return this.completedOpCount.sum();
    }

    @Override
    public final boolean isIdle() {
        return true;
    }

    @Override
    public final void adjustIoBuffers(long avgTransferSize, OpType opType) {
    }

    @Override
    protected void doStart() throws IllegalStateException {
        Loggers.MSG.debug("{}: started", (Object)this.toString());
    }

    @Override
    protected final void doShutdown() throws IllegalStateException {
        Loggers.MSG.debug("{}: shut down", (Object)this.toString());
    }

    @Override
    public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return true;
    }

    @Override
    protected final void doStop() throws IllegalStateException {
        Loggers.MSG.debug("{}: stopped", (Object)this.toString());
    }

    @Override
    protected final void doClose() throws IOException {
        this.opResultOut = null;
        Loggers.MSG.debug("{}: closed", (Object)this.toString());
    }

    public final String toString() {
        return String.format(super.toString(), "mock-dummy");
    }
}

