/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.svc;

import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.svc.Service;
import com.emc.mongoose.base.svc.ServiceUtil;
import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

public abstract class ServiceBase
extends AsyncRunnableBase
implements Service {
    protected final int port;

    protected ServiceBase(int port) {
        this.port = port;
    }

    @Override
    public final int registryPort() {
        return this.port;
    }

    @Override
    protected void doStart() {
        try {
            try {
                ServiceUtil.create(this, this.port);
            }
            catch (MalformedURLException | SocketException | URISyntaxException | RemoteException e) {
                LogUtil.exception(Level.ERROR, e, "Failed to start the service \"{}\" @ port #{}", this.name(), this.port);
            }
            Loggers.MSG.info("Service \"{}\" started @ port #{}", (Object)this.name(), (Object)this.port);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected void doStop() {
        try {
            ServiceUtil.close(this);
            Loggers.MSG.info("Service \"{}\" stopped listening the port #{}", (Object)this.name(), (Object)this.port);
        }
        catch (MalformedURLException | RemoteException e) {
            try {
                throw new RemoteException("Failed to stop the service " + this.name(), e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

