/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.svc;

import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.svc.Service;
import com.github.akurilov.commons.net.FixedPortRmiSocketFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Level;

public abstract class ServiceUtil {
    private static final Map<Integer, WeakReference<Registry>> REGISTRY_MAP = new HashMap<Integer, WeakReference<Registry>>();
    private static final String RMI_SCHEME = "rmi";
    private static final String KEY_RMI_HOSTNAME = "java.rmi.server.hostname";
    private static final Map<String, WeakReference<Service>> SVC_MAP = new HashMap<String, WeakReference<Service>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureRmiRegistryIsAvailableAt(int port) throws RemoteException {
        Map<Integer, WeakReference<Registry>> map = REGISTRY_MAP;
        synchronized (map) {
            if (!REGISTRY_MAP.containsKey(port)) {
                try {
                    REGISTRY_MAP.put(port, new WeakReference<Registry>(LocateRegistry.createRegistry(port)));
                }
                catch (RemoteException e) {
                    REGISTRY_MAP.put(port, new WeakReference<Registry>(LocateRegistry.getRegistry(port)));
                }
            }
        }
    }

    private static void ensureRmiUseFixedPort(int port) throws IOException, IllegalStateException {
        RMISocketFactory prevSocketFactory = RMISocketFactory.getSocketFactory();
        if (prevSocketFactory == null) {
            RMISocketFactory.setSocketFactory(new FixedPortRmiSocketFactory(port));
        } else if (prevSocketFactory instanceof FixedPortRmiSocketFactory) {
            ((FixedPortRmiSocketFactory)prevSocketFactory).setFixedPort(port);
        } else {
            throw new IllegalStateException("Invalid RMI socket factory was set");
        }
    }

    public static URI getLocalSvcUri(String svcName, int port) throws URISyntaxException, SocketException {
        String hostName = ServiceUtil.getAnyExternalHostAddress();
        return new URI(RMI_SCHEME, null, hostName, port, "/" + svcName, null, null);
    }

    private static URI getRemoteSvcUri(String addr, String svcName) throws URISyntaxException {
        int portPos = addr.lastIndexOf(":");
        if (portPos < 0) {
            throw new URISyntaxException(addr, "No port information in the address");
        }
        int port = Integer.parseInt(addr.substring(portPos + 1));
        return ServiceUtil.getRemoteSvcUri(addr.substring(0, portPos), port, svcName);
    }

    private static URI getRemoteSvcUri(String addr, int port, String svcName) throws URISyntaxException {
        return new URI(RMI_SCHEME, null, addr, port, "/" + svcName, null, null);
    }

    public static String getAnyExternalHostAddress() throws SocketException {
        String hostName = System.getProperty(KEY_RMI_HOSTNAME);
        if (hostName != null) {
            return hostName;
        }
        return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(Objects::nonNull).filter(netIface -> {
            try {
                return !netIface.isLoopback() && netIface.isUp();
            }
            catch (SocketException e) {
                return false;
            }
        }).map(NetworkInterface::getInetAddresses).map(inetAddrs -> Collections.list(inetAddrs).stream().filter(inetAddr -> inetAddr instanceof Inet4Address).map(InetAddress::getHostAddress).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(InetAddress.getLoopbackAddress().getHostAddress());
    }

    public static boolean isLocalAddress(String addrWithPort) {
        int portSepPos = addrWithPort.lastIndexOf(58);
        String addr = portSepPos == -1 ? addrWithPort : addrWithPort.substring(0, portSepPos);
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().map(NetworkInterface::getInetAddresses).anyMatch(ifaceAddrs -> Collections.list(ifaceAddrs).stream().anyMatch(inetAddress -> addr.equals(inetAddress.getCanonicalHostName()) || addr.equals(inetAddress.getHostName()) || addr.equals(inetAddress.getHostAddress())));
        }
        catch (SocketException e) {
            LogUtil.trace(Loggers.ERR, Level.WARN, e, "Failed to list the network interfaces to find the local one", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String create(Service svc, int port) throws URISyntaxException, MalformedURLException, SocketException, RemoteException {
        String svcUri = null;
        Map<String, WeakReference<Service>> map = SVC_MAP;
        synchronized (map) {
            ServiceUtil.ensureRmiRegistryIsAvailableAt(port);
            UnicastRemoteObject.exportObject((Remote)svc, port);
            String svcName = svc.name();
            svcUri = ServiceUtil.getLocalSvcUri(svcName, port).toString();
            if (SVC_MAP.containsKey(svcName + ":" + port)) {
                throw new AssertionError((Object)"Service already registered");
            }
            Naming.rebind(svcUri, svc);
            SVC_MAP.put(svcName + ":" + port, new WeakReference<Service>(svc));
        }
        return svcUri;
    }

    public static <S extends Service> S resolve(String addr, String name) throws NotBoundException, RemoteException, URISyntaxException, MalformedURLException {
        String svcUri = ServiceUtil.getRemoteSvcUri(addr, name).toString();
        return (S)((Service)Naming.lookup(svcUri));
    }

    public static <S extends Service> S resolve(String addr, int port, String name) throws NotBoundException, IOException, URISyntaxException {
        String svcUri = ServiceUtil.getRemoteSvcUri(addr, port, name).toString();
        return (S)((Service)Naming.lookup(svcUri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String close(Service svc) throws RemoteException, MalformedURLException {
        String svcName = svc.name();
        String svcUri = null;
        try {
            UnicastRemoteObject.unexportObject(svc, true);
        }
        finally {
            try {
                svcUri = ServiceUtil.getLocalSvcUri(svcName, svc.registryPort()).toString();
                Naming.unbind(svcUri);
                Map<String, WeakReference<Service>> map = SVC_MAP;
                synchronized (map) {
                    if (null == SVC_MAP.remove(svcName + ":" + svc.registryPort())) {
                        System.err.println("Failed to remove the service \"" + svcName + "\"");
                    }
                }
            }
            catch (SocketException | URISyntaxException | NotBoundException e) {
                LogUtil.trace(Loggers.ERR, Level.WARN, e, "Failed to close the RMI service", new Object[0]);
            }
        }
        return svcUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdown() {
        Map<Object, WeakReference<Remote>> map = SVC_MAP;
        synchronized (map) {
            while (true) {
                if (SVC_MAP.isEmpty()) {
                    SVC_MAP.clear();
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var0 /* !! */ 
                    map = REGISTRY_MAP;
                    synchronized (map) {
                        REGISTRY_MAP.clear();
                        return;
                    }
                }
                Service svc = (Service)SVC_MAP.values().iterator().next().get();
                if (svc == null) continue;
                try {
                    System.out.println("Service closed: " + ServiceUtil.close(svc));
                }
                catch (MalformedURLException | RemoteException e) {
                    LogUtil.trace(Loggers.ERR, Level.WARN, e, "Failed to close the RMI service", new Object[0]);
                    continue;
                }
                break;
            }
        }
    }
}

