/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.LongAdder;

public class BoundedPriorityBlockngQueue<E>
extends PriorityBlockingQueue<E>
implements BlockingQueue<E> {
    private final int capacity;
    private final LongAdder size = new LongAdder();

    public BoundedPriorityBlockngQueue(int capacity, Comparator<E> comparator) {
        super(capacity, comparator);
        this.capacity = capacity;
    }

    @Override
    public boolean offer(E element) {
        if (this.size.sum() < (long)this.capacity) {
            if (super.offer(element)) {
                this.size.increment();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int n = super.drainTo(c, maxElements);
        this.size.add(-n);
        return n;
    }
}

