/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class TextStreamInput
implements Input<String> {
    private final BufferedReader reader;

    public TextStreamInput(InputStream input) {
        this.reader = new BufferedReader(new InputStreamReader(input));
    }

    public TextStreamInput(InputStream input, int buffSize) {
        this.reader = new BufferedReader(new InputStreamReader(input), buffSize);
    }

    @Override
    public String get() {
        String nextLine = null;
        try {
            nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        if (nextLine == null) {
            Exceptions.throwUnchecked(new EOFException());
        }
        return nextLine;
    }

    @Override
    public int get(List<String> buffer, int limit) {
        int i;
        block5: {
            try {
                for (i = 0; i < limit; ++i) {
                    String nextLine = this.reader.readLine();
                    if (nextLine == null) {
                        if (i == 0) {
                            throw new EOFException();
                        }
                        break;
                    }
                    buffer.add(nextLine);
                }
            }
            catch (IOException e) {
                if (i != 0) break block5;
                Exceptions.throwUnchecked(e);
            }
        }
        return i;
    }

    @Override
    public long skip(long count) {
        try {
            return this.reader.skip(count);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return count;
        }
    }

    @Override
    public void reset() {
        try {
            this.reader.reset();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }
}

