/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.BinInput;
import com.github.akurilov.commons.io.file.FileInput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class BinFileInput<T>
extends BinInput<T>
implements FileInput<T> {
    protected final Path srcPath;

    public BinFileInput(Path srcPath) {
        super(BinFileInput.buildObjectInputStream(srcPath));
        this.srcPath = srcPath;
    }

    protected static ObjectInputStream buildObjectInputStream(Path itemsSrcPath) {
        try {
            return new ObjectInputStream(new BufferedInputStream(Files.newInputStream(itemsSrcPath, INPUT_OPEN_OPTIONS)));
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public String toString() {
        return "binFileInput<" + this.srcPath.getFileName() + ">";
    }

    @Override
    public final Path filePath() {
        return this.srcPath;
    }

    @Override
    public void reset() {
        if (this.itemsSrc != null) {
            try {
                this.itemsSrc.close();
            }
            catch (IOException e) {
                Exceptions.throwUnchecked(e);
            }
        }
        this.setItemsSrc(BinFileInput.buildObjectInputStream(this.srcPath));
    }
}

