/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.TextStreamInput;
import com.github.akurilov.commons.io.file.FileInput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class TextFileInput
extends TextStreamInput
implements FileInput<String> {
    private final Path filePath;

    public TextFileInput(Path filePath) {
        super(TextFileInput.open(filePath));
        this.filePath = filePath;
    }

    static InputStream open(Path filePath) {
        try {
            return Files.newInputStream(filePath, INPUT_OPEN_OPTIONS);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public Path filePath() {
        return this.filePath;
    }
}

