/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.system;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SizeInBytes
implements Serializable {
    private static final String FMT_MSG_INVALID_SIZE = "The string \"%s\" doesn't match the pattern: \"%s\"";
    public static final String SIZE_UNITS = "kmgtpe";
    public static final Pattern PATTERN_SIZE = Pattern.compile("([\\d\\.]+)([kmgtpe]?)b?");
    private static final char SEP1 = '-';
    private static final char SEP2 = ',';
    private long min;
    private long range = 0L;
    private double bias = 1.0;
    private static final int APPROXIMATION_COUNT = 100;
    private static final ThreadLocal<StringBuilder> STRING_BULDER = ThreadLocal.withInitial(StringBuilder::new);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long toFixedSize(String value) throws NumberFormatException {
        long degree;
        Matcher matcher = PATTERN_SIZE.matcher(value.toLowerCase());
        if (!matcher.matches() || matcher.groupCount() <= 0 || matcher.groupCount() >= 3) throw new IllegalArgumentException(String.format(FMT_MSG_INVALID_SIZE, value, PATTERN_SIZE));
        double size = Double.parseDouble(matcher.group(1));
        String unit = matcher.group(2);
        if (unit.length() == 0) {
            degree = 0L;
            return (long)(size *= (double)(1L << (int)(10L * degree)));
        } else {
            if (unit.length() != 1) throw new IllegalArgumentException(String.format(FMT_MSG_INVALID_SIZE, value, PATTERN_SIZE));
            degree = SIZE_UNITS.indexOf(matcher.group(2)) + 1;
        }
        return (long)(size *= (double)(1L << (int)(10L * degree)));
    }

    public static String formatFixedSize(long v) {
        if (v < 1024L) {
            return v + "B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        double x = (double)v / (double)(1L << z * 10);
        if (x % 1.0 == 0.0) {
            long y = (long)x;
            return String.format(Locale.ROOT, y < 10L ? "%d%sb" : (y < 100L ? "%d%sb" : "%d%sb"), y, z > 0 ? Character.valueOf(SIZE_UNITS.charAt(z - 1)) : "").toUpperCase();
        }
        return String.format(Locale.ROOT, x < 10.0 ? "%.3f%sb" : (x < 100.0 ? "%.2f%sb" : "%.1f%sb"), x, z > 0 ? Character.valueOf(SIZE_UNITS.charAt(z - 1)) : "").toUpperCase();
    }

    public SizeInBytes(String sizeInfo) throws NumberFormatException, IllegalArgumentException {
        int sep1pos = sizeInfo.indexOf(45, 0);
        int sep2pos = sizeInfo.indexOf(44, 0);
        if (sep1pos < 0) {
            this.min = SizeInBytes.toFixedSize(sizeInfo);
        } else {
            this.min = SizeInBytes.toFixedSize(sizeInfo.substring(0, sep1pos));
            if (sep2pos < 0) {
                this.range = SizeInBytes.toFixedSize(sizeInfo.substring(sep1pos + 1)) - this.min;
            } else {
                this.range = SizeInBytes.toFixedSize(sizeInfo.substring(sep1pos + 1, sep2pos)) - this.min;
                this.bias = Double.parseDouble(sizeInfo.substring(sep2pos + 1));
            }
        }
        if (this.range < 0L) {
            throw new IllegalArgumentException("Min value is less than max: \"" + sizeInfo + "\"");
        }
    }

    public SizeInBytes(long size) {
        this(size, size, 1.0);
    }

    public SizeInBytes(long min, long max, double bias) {
        if (min < 0L) {
            throw new IllegalArgumentException("Min size is less than 0");
        }
        if (min > max) {
            throw new IllegalArgumentException("Min size is more than max");
        }
        this.min = min;
        this.range = max - min;
        this.bias = bias;
    }

    public SizeInBytes(SizeInBytes other) {
        this.min = other.min;
        this.range = other.range;
        this.bias = other.bias;
    }

    public long get() {
        if (this.range == 0L) {
            return this.min;
        }
        if (this.bias == 1.0) {
            return this.min + ThreadLocalRandom.current().nextLong(this.range + 1L);
        }
        return this.min + (long)(Math.pow(ThreadLocalRandom.current().nextDouble(), this.bias) * (double)this.range);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.min + this.range;
    }

    public final long getAvg() {
        if (this.range == 0L) {
            return this.min;
        }
        long sum = 0L;
        for (int i = 0; i < 100; ++i) {
            sum += this.get();
        }
        return sum / 100L;
    }

    public final String toString() {
        StringBuilder sb = STRING_BULDER.get();
        sb.setLength(0);
        sb.append(SizeInBytes.formatFixedSize(this.min));
        if (this.range > 0L) {
            sb.append('-').append(SizeInBytes.formatFixedSize(this.min + this.range));
            if (this.bias != 1.0) {
                sb.append(',').append(Double.toString(this.bias));
            }
        }
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof SizeInBytes) {
            SizeInBytes s = (SizeInBytes)o;
            return this.min == s.min && this.range == s.range && this.bias == s.bias;
        }
        return false;
    }
}

