/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.confuse.io.yaml;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.ConfigProvider;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class YamlConfigProviderBase
implements ConfigProvider {
    @Override
    public Config config(String pathSep, Map<String, Object> schema) throws IOException {
        Map configTree;
        ObjectMapper mapper = new YAMLMapper().enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).enable(SerializationFeature.INDENT_OUTPUT);
        try (InputStream input = this.configInputStream();){
            configTree = (Map)mapper.readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return new BasicConfig(pathSep, schema, configTree);
    }

    protected abstract InputStream configInputStream() throws IOException;
}

