/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.fiber4j.FiberBase;
import com.github.akurilov.fiber4j.FibersExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ExclusiveFiberBase
extends FiberBase {
    private final Lock invocationLock;

    protected ExclusiveFiberBase(FibersExecutor executor) {
        this(executor, new ReentrantLock());
    }

    protected ExclusiveFiberBase(FibersExecutor executor, Lock invocationLock) {
        super(executor);
        this.invocationLock = invocationLock;
    }

    @Override
    protected final void invokeTimed(long startTimeNanos) {
        if (this.invocationLock.tryLock()) {
            try {
                this.invokeTimedExclusively(startTimeNanos);
            }
            finally {
                this.invocationLock.unlock();
            }
        }
    }

    protected abstract void invokeTimedExclusively(long var1);
}

