/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import com.github.akurilov.fiber4j.Fiber;
import com.github.akurilov.fiber4j.FibersExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FiberBase
extends AsyncRunnableBase
implements Fiber {
    private static final Logger LOG = Logger.getLogger(FiberBase.class.getSimpleName());
    private final FibersExecutor executor;

    protected FiberBase(FibersExecutor executor) {
        this.executor = executor;
    }

    @Override
    protected void doStart() {
        this.executor.start(this);
    }

    @Override
    public final void invoke() {
        long t = System.nanoTime();
        this.invokeTimed(t);
        t = System.nanoTime() - t;
        if (t > 1000000000L) {
            LOG.log(t > 10000000000L ? Level.WARNING : Level.FINE, "Fiber \"" + this + "\" invocation duration (" + TimeUnit.NANOSECONDS.toMillis(t) + "[ms]) exceeds the limit (" + TimeUnit.NANOSECONDS.toMillis(10000000L) + "[ms])");
        }
    }

    protected abstract void invokeTimed(long var1);

    @Override
    protected void doStop() {
        this.executor.stop(this);
    }
}

