/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import com.github.akurilov.fiber4j.Fiber;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FibersExecutorTask
extends AsyncRunnableBase
implements Runnable {
    private static final Logger LOG = Logger.getLogger(FibersExecutorTask.class.getName());
    private final Queue<Fiber> fibers;
    private final boolean backgroundFlag;

    public FibersExecutorTask(Queue<Fiber> fibers, boolean backgroundFlag) {
        this.fibers = fibers;
        this.backgroundFlag = backgroundFlag;
    }

    @Override
    public final void run() {
        while (this.isStarted()) {
            if (this.fibers.size() == 0) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            for (Fiber nextFiber : this.fibers) {
                try {
                    if (nextFiber.isStarted() || nextFiber.isShutdown()) {
                        nextFiber.invoke();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Fiber \"" + nextFiber + "\" failed", t);
                }
                if (!this.backgroundFlag) continue;
                LockSupport.parkNanos(1L);
            }
        }
    }
}

