/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.commons.collection.CircularArrayBuffer;
import com.github.akurilov.commons.collection.CircularBuffer;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.fiber4j.FiberBase;
import com.github.akurilov.fiber4j.FibersExecutor;
import com.github.akurilov.fiber4j.OutputFiber;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RoundRobinOutputFiber<T, O extends Output<T>>
extends FiberBase
implements OutputFiber<T> {
    private static final Logger LOG = Logger.getLogger(RoundRobinOutputFiber.class.getName());
    private final List<O> outputs;
    private final int outputsCount;
    private final AtomicLong putCounter = new AtomicLong(0L);
    private final AtomicLong getCounter = new AtomicLong(0L);
    private final int buffCapacity;
    private final Map<O, CircularBuffer<T>> buffs;
    private final Map<O, Lock> buffLocks;

    public RoundRobinOutputFiber(FibersExecutor executor, List<O> outputs, int buffCapacity) {
        super(executor);
        this.outputs = outputs;
        this.outputsCount = outputs.size();
        this.buffCapacity = buffCapacity;
        this.buffs = new HashMap<O, CircularBuffer<T>>(this.outputsCount);
        this.buffLocks = new HashMap<O, Lock>(this.outputsCount);
        for (int i = 0; i < this.outputsCount; ++i) {
            CircularArrayBuffer buff = new CircularArrayBuffer(buffCapacity);
            this.buffs.put((Output)outputs.get(i), buff);
            this.buffLocks.put((Output)outputs.get(i), new ReentrantLock());
        }
    }

    private O selectOutput() {
        if (this.outputsCount > 1) {
            return (O)((Output)this.outputs.get((int)(this.putCounter.getAndIncrement() % (long)this.outputsCount)));
        }
        return (O)((Output)this.outputs.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(T ioTask) throws IOException {
        if (this.isStopped()) {
            throw new EOFException();
        }
        O output = this.selectOutput();
        CircularBuffer<T> dstBuff = this.buffs.get(output);
        Lock dstBuffLock = this.buffLocks.get(output);
        if (dstBuff != null && dstBuffLock != null && dstBuffLock.tryLock()) {
            try {
                boolean bl = dstBuff.add(ioTask);
                return bl;
            }
            finally {
                dstBuffLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int put(List<T> srcBuff, int from, int to) throws IOException {
        int offset;
        if (this.isStopped()) {
            throw new EOFException();
        }
        int n = to - from;
        if (n > this.outputsCount) {
            int nPerOutput = n / this.outputsCount;
            while (offset < to) {
                O output = this.selectOutput();
                CircularBuffer<T> dstBuff = this.buffs.get(output);
                Lock dstBuffLock = this.buffLocks.get(output);
                if (dstBuff == null || dstBuffLock == null || !dstBuffLock.tryLock()) continue;
                try {
                    int m = Math.min(Math.min(nPerOutput, to - offset), this.buffCapacity - dstBuff.size());
                    List<T> items = srcBuff.subList(offset, offset + m);
                    if (dstBuff.addAll(items)) {
                        offset += m;
                        continue;
                    }
                    throw new AssertionError();
                }
                finally {
                    dstBuffLock.unlock();
                }
            }
            return offset - from;
        }
        for (offset = from; offset < to; ++offset) {
            O output = this.selectOutput();
            CircularBuffer<T> dstBuff = this.buffs.get(output);
            Lock dstBuffLock = this.buffLocks.get(output);
            if (dstBuff != null && dstBuffLock != null && dstBuffLock.tryLock()) {
                try {
                    if (dstBuff.add(srcBuff.get(offset))) continue;
                    int n2 = offset - from;
                    return n2;
                }
                finally {
                    dstBuffLock.unlock();
                }
            }
            return offset - from;
        }
        return to - from;
    }

    @Override
    public final int put(List<T> buffer) throws IOException {
        return this.put(buffer, 0, buffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invokeTimed(long startTimeNanos) {
        Output output = (Output)this.outputs.get(this.outputsCount > 1 ? (int)(this.getCounter.getAndIncrement() % (long)this.outputsCount) : 0);
        CircularBuffer<T> srcBuff = this.buffs.get(output);
        Lock srcBuffLock = this.buffLocks.get(output);
        if (srcBuff != null && srcBuffLock != null && srcBuffLock.tryLock()) {
            try {
                int n = srcBuff.size();
                if (n > 0) {
                    if (n == 1) {
                        if (output.put(srcBuff.get(0))) {
                            srcBuff.clear();
                        }
                    } else {
                        n = output.put(srcBuff);
                        srcBuff.removeFirst(n);
                    }
                }
            }
            catch (EOFException | ConnectException | NoSuchObjectException n) {
            }
            catch (RemoteException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof EOFException)) {
                    LOG.log(Level.WARNING, "Invocation failure", e);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Invocation failure", t);
            }
            finally {
                srcBuffLock.unlock();
            }
        }
    }

    @Override
    public final Input<T> getInput() {
        throw new AssertionError((Object)"Shouldn't be invoked");
    }

    @Override
    protected final void doClose() throws IOException {
        this.outputs.stream().map(this.buffs::get).filter(Objects::nonNull).forEach(List::clear);
        this.buffs.clear();
        this.buffLocks.clear();
    }
}

