/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.generator;

import com.emc.mongoose.common.api.SizeInBytes;
import com.emc.mongoose.common.collection.OptLockArrayBuffer;
import com.emc.mongoose.common.collection.OptLockBuffer;
import com.emc.mongoose.common.concurrent.SvcTask;
import com.emc.mongoose.common.concurrent.Throttle;
import com.emc.mongoose.common.concurrent.WeightThrottle;
import com.emc.mongoose.common.exception.UserShootHisFootException;
import com.emc.mongoose.common.io.Input;
import com.emc.mongoose.common.io.Output;
import com.emc.mongoose.model.DaemonBase;
import com.emc.mongoose.model.io.IoType;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.io.task.IoTaskBuilder;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.model.load.LoadGenerator;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public class BasicLoadGenerator<I extends Item, O extends IoTask<I>>
extends DaemonBase
implements LoadGenerator<I, O>,
SvcTask {
    private volatile WeightThrottle weightThrottle = null;
    private volatile Throttle<Object> rateThrottle = null;
    private volatile Output<O> ioTaskOutput;
    private volatile boolean itemInputFinishFlag = false;
    private volatile boolean taskInputFinishFlag = false;
    private volatile boolean outputFinishFlag = false;
    private final int batchSize;
    private final Input<I> itemInput;
    private final Lock inputLock = new ReentrantLock();
    private final long transferSizeEstimate;
    private final Random rnd;
    private final long countLimit;
    private final boolean shuffleFlag;
    private final IoTaskBuilder<I, O> ioTaskBuilder;
    private final int originCode;
    private final LongAdder builtTasksCounter = new LongAdder();
    private final LongAdder outputTaskCounter = new LongAdder();
    private final String name;
    private final ThreadLocal<OptLockBuffer<O>> threadLocalTasksBuff = new ThreadLocal();

    public BasicLoadGenerator(Input<I> itemInput, int batchSize, long transferSizeEstimate, IoTaskBuilder<I, O> ioTaskBuilder, long countLimit, SizeInBytes sizeLimit, boolean shuffleFlag) throws UserShootHisFootException {
        this.batchSize = batchSize;
        this.itemInput = itemInput;
        this.transferSizeEstimate = transferSizeEstimate;
        this.ioTaskBuilder = ioTaskBuilder;
        this.originCode = ioTaskBuilder.getOriginCode();
        this.countLimit = countLimit > 0L ? countLimit : (sizeLimit.get() > 0L && this.transferSizeEstimate > 0L ? sizeLimit.get() / this.transferSizeEstimate : Long.MAX_VALUE);
        this.shuffleFlag = shuffleFlag;
        this.rnd = shuffleFlag ? new Random() : null;
        String ioStr = ioTaskBuilder.getIoType().toString();
        this.name = Character.toUpperCase(ioStr.charAt(0)) + ioStr.substring(1).toLowerCase() + (countLimit > 0L && countLimit < Long.MAX_VALUE ? Long.toString(countLimit) : "") + itemInput.toString();
        this.svcTasks.add(this);
    }

    public final void setWeightThrottle(WeightThrottle weightThrottle) {
        this.weightThrottle = weightThrottle;
    }

    public final void setRateThrottle(Throttle<Object> rateThrottle) {
        this.rateThrottle = rateThrottle;
    }

    public final void setOutput(Output<O> ioTaskOutput) {
        this.ioTaskOutput = ioTaskOutput;
    }

    public final long getGeneratedIoTasksCount() {
        return this.builtTasksCounter.sum();
    }

    public final long getTransferSizeEstimate() {
        return this.transferSizeEstimate;
    }

    public final IoType getIoType() {
        return this.ioTaskBuilder.getIoType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        block51: {
            OptLockArrayBuffer tasksBuff = this.threadLocalTasksBuff.get();
            if (tasksBuff == null) {
                tasksBuff = new OptLockArrayBuffer(this.batchSize);
                this.threadLocalTasksBuff.set((OptLockBuffer<O>)tasksBuff);
            }
            int pendingTasksCount = tasksBuff.size();
            int n = this.batchSize - pendingTasksCount;
            try (CloseableThreadContext.Instance ctx2 = CloseableThreadContext.put((String)"class.name", (String)((Object)((Object)this)).getClass().getSimpleName());){
                block50: {
                    if (n > 0 && !this.itemInputFinishFlag && this.inputLock.tryLock()) {
                        try {
                            long remainingTasksCount = this.countLimit - this.builtTasksCounter.sum();
                            if (remainingTasksCount <= 0L) break block50;
                            n = (int)Math.min(remainingTasksCount, (long)n);
                            ArrayList items = new ArrayList(n);
                            try {
                                this.itemInput.get(items, n);
                            }
                            catch (EOFException e) {
                                Loggers.MSG.debug("{}: end of items input @ the count {}", (Object)this.toString(), (Object)this.builtTasksCounter.sum());
                                this.itemInputFinishFlag = true;
                            }
                            n = items.size();
                            if (n > 0) {
                                if (this.shuffleFlag) {
                                    Collections.shuffle(items, this.rnd);
                                }
                                try {
                                    this.ioTaskBuilder.getInstances(items, (List)tasksBuff);
                                    pendingTasksCount += n;
                                    this.builtTasksCounter.add(n);
                                }
                                catch (IllegalArgumentException e) {
                                    LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to generate the I/O task", (Object[])new Object[0]);
                                }
                            }
                            if (this.itemInputFinishFlag) {
                                this.taskInputFinishFlag = true;
                            }
                        }
                        finally {
                            this.inputLock.unlock();
                        }
                    }
                }
                if (pendingTasksCount <= 0) break block51;
                n = pendingTasksCount;
                if (this.weightThrottle != null) {
                    n = this.weightThrottle.tryAcquire(this.originCode, n);
                }
                if (this.rateThrottle != null) {
                    n = this.rateThrottle.tryAcquire((Object)this.originCode, n);
                }
                if (n <= 0) break block51;
                if (n == 1) {
                    try {
                        IoTask task = (IoTask)tasksBuff.get(0);
                        if (!this.ioTaskOutput.put((Object)task)) break block51;
                        this.outputTaskCounter.increment();
                        if (pendingTasksCount == 1) {
                            tasksBuff.clear();
                            break block51;
                        }
                        tasksBuff.remove(0);
                    }
                    catch (EOFException e) {
                        Loggers.MSG.debug("{}: finish due to output's EOF", (Object)this.toString());
                        this.outputFinishFlag = true;
                    }
                    catch (RemoteException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof EOFException) {
                            Loggers.MSG.debug("{}: finish due to output's EOF", (Object)this.toString());
                            this.outputFinishFlag = true;
                            break block51;
                        }
                        LogUtil.exception((Level)Level.ERROR, (Throwable)cause, (String)"Unexpected failure", (Object[])new Object[0]);
                        e.printStackTrace(System.err);
                    }
                    break block51;
                }
                try {
                    n = this.ioTaskOutput.put((List)tasksBuff, 0, n);
                    this.outputTaskCounter.add(n);
                    if (n < pendingTasksCount) {
                        tasksBuff.removeRange(0, n);
                        break block51;
                    }
                    tasksBuff.clear();
                }
                catch (EOFException e) {
                    Loggers.MSG.debug("{}: finish due to output's EOF", (Object)this.toString());
                    this.outputFinishFlag = true;
                }
                catch (RemoteException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof EOFException) {
                        Loggers.MSG.debug("{}: finish due to output's EOF", (Object)this.toString());
                        this.outputFinishFlag = true;
                        break block51;
                    }
                    LogUtil.exception((Level)Level.ERROR, (Throwable)cause, (String)"Unexpected failure", (Object[])new Object[0]);
                    e.printStackTrace(System.err);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof EOFException)) {
                    LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Unexpected failure", (Object[])new Object[0]);
                    t.printStackTrace(System.err);
                }
            }
            finally {
                if (this.outputFinishFlag || this.itemInputFinishFlag && this.taskInputFinishFlag && this.builtTasksCounter.sum() == this.outputTaskCounter.sum()) {
                    try {
                        this.shutdown();
                    }
                    catch (IllegalStateException ctx2) {}
                }
            }
        }
    }

    protected final void doShutdown() {
        this.interrupt();
    }

    protected final void doInterrupt() {
        this.svcTasks.remove((Object)this);
        Loggers.MSG.debug("{}: generated {}, output {} I/O tasks", (Object)this.toString(), (Object)this.builtTasksCounter.sum(), (Object)this.outputTaskCounter.sum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long t;
        for (long remainingMillis = timeUnit.toMillis(timeout); remainingMillis > 0L; remainingMillis -= t) {
            t = System.currentTimeMillis();
            Object object = this.state;
            synchronized (object) {
                this.state.wait(remainingMillis);
            }
            if (!this.isStarted()) {
                return true;
            }
            t = System.currentTimeMillis() - t;
        }
        return false;
    }

    protected final void doClose() throws IOException {
        super.doClose();
        if (this.itemInput != null) {
            try {
                this.inputLock.tryLock(250L, TimeUnit.MILLISECONDS);
                this.itemInput.close();
            }
            catch (Exception e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"{}: failed to close the item input", (Object[])new Object[]{this.toString()});
            }
        }
        this.ioTaskBuilder.close();
        this.ioTaskOutput.close();
    }

    public final String toString() {
        return this.name;
    }

    public final int hashCode() {
        return this.originCode;
    }
}

