/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.generator;

import com.emc.mongoose.common.api.ByteRange;
import com.emc.mongoose.common.api.SizeInBytes;
import com.emc.mongoose.common.exception.UserShootHisFootException;
import com.emc.mongoose.common.io.Input;
import com.emc.mongoose.common.supply.BatchSupplier;
import com.emc.mongoose.common.supply.ConstantStringSupplier;
import com.emc.mongoose.common.supply.RangePatternDefinedSupplier;
import com.emc.mongoose.load.generator.BasicLoadGenerator;
import com.emc.mongoose.load.generator.LoadGeneratorBuilder;
import com.emc.mongoose.load.generator.StorageItemInput;
import com.emc.mongoose.model.io.IoType;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.io.task.data.BasicDataIoTaskBuilder;
import com.emc.mongoose.model.io.task.data.DataIoTaskBuilder;
import com.emc.mongoose.model.io.task.path.BasicPathIoTaskBuilder;
import com.emc.mongoose.model.io.task.token.BasicTokenIoTaskBuilder;
import com.emc.mongoose.model.item.BasicDataItemFactory;
import com.emc.mongoose.model.item.ChainTransferBuffer;
import com.emc.mongoose.model.item.CsvFileItemInput;
import com.emc.mongoose.model.item.DataItem;
import com.emc.mongoose.model.item.IdStringInput;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.model.item.ItemFactory;
import com.emc.mongoose.model.item.ItemNameSupplier;
import com.emc.mongoose.model.item.ItemNamingType;
import com.emc.mongoose.model.item.ItemType;
import com.emc.mongoose.model.item.NewDataItemInput;
import com.emc.mongoose.model.item.NewItemInput;
import com.emc.mongoose.model.storage.StorageDriver;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class BasicLoadGeneratorBuilder<I extends Item, O extends IoTask<I>, T extends BasicLoadGenerator<I, O>>
implements LoadGeneratorBuilder<I, O, T> {
    private Config.ItemConfig itemConfig;
    private Config.LoadConfig loadConfig;
    private Config.TestConfig.StepConfig.LimitConfig limitConfig;
    private ItemType itemType;
    private ItemFactory<I> itemFactory;
    private Config.StorageConfig.AuthConfig authConfig;
    private List<StorageDriver<I, O>> storageDrivers;
    private Input<I> itemInput = null;
    private long sizeEstimate = 0L;
    private int batchSize;

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setItemConfig(Config.ItemConfig itemConfig) {
        this.itemConfig = itemConfig;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setLoadConfig(Config.LoadConfig loadConfig) {
        this.loadConfig = loadConfig;
        this.batchSize = loadConfig.getBatchConfig().getSize();
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setLimitConfig(Config.TestConfig.StepConfig.LimitConfig limitConfig) {
        this.limitConfig = limitConfig;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setItemType(ItemType itemType) {
        this.itemType = itemType;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setItemFactory(ItemFactory<I> itemFactory) {
        this.itemFactory = itemFactory;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setAuthConfig(Config.StorageConfig.AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setStorageDrivers(List<StorageDriver<I, O>> storageDrivers) {
        this.storageDrivers = storageDrivers;
        return this;
    }

    @Override
    public BasicLoadGeneratorBuilder<I, O, T> setItemInput(Input<I> itemInput) {
        this.itemInput = itemInput;
        if (!(itemInput instanceof ChainTransferBuffer)) {
            this.sizeEstimate = BasicLoadGeneratorBuilder.estimateTransferSize(null, IoType.valueOf((String)this.loadConfig.getType().toUpperCase()), itemInput);
        }
        return this;
    }

    @Override
    public T build() throws UserShootHisFootException {
        String uid;
        Object ioTaskBuilder;
        IoType ioType = IoType.valueOf((String)this.loadConfig.getType().toUpperCase());
        long countLimit = this.limitConfig.getCount();
        SizeInBytes sizeLimit = this.limitConfig.getSize();
        boolean shuffleFlag = this.loadConfig.getGeneratorConfig().getShuffle();
        Config.ItemConfig.InputConfig inputConfig = this.itemConfig.getInputConfig();
        BatchSupplier<String> outputPathSupplier = IoType.CREATE.equals((Object)ioType) && ItemType.DATA.equals((Object)this.itemType) ? this.getOutputPathSupplier() : null;
        if (ItemType.DATA.equals((Object)this.itemType)) {
            Config.ItemConfig.DataConfig.RangesConfig rangesConfig = this.itemConfig.getDataConfig().getRangesConfig();
            List fixedRangesConfig = rangesConfig.getFixed();
            List fixedRanges = fixedRangesConfig != null ? fixedRangesConfig.stream().map(ByteRange::new).collect(Collectors.toList()) : Collections.EMPTY_LIST;
            ioTaskBuilder = new BasicDataIoTaskBuilder().setFixedRanges(fixedRanges).setRandomRangesCount(rangesConfig.getRandom()).setSizeThreshold(rangesConfig.getThreshold().get());
        } else {
            ioTaskBuilder = ItemType.PATH.equals((Object)this.itemType) ? new BasicPathIoTaskBuilder() : new BasicTokenIoTaskBuilder();
        }
        String itemInputPath = inputConfig.getPath();
        if (itemInputPath != null && itemInputPath.indexOf(47) != 0) {
            itemInputPath = '/' + itemInputPath;
        }
        Object uidSupplier = (uid = this.authConfig.getUid()) == null ? null : (-1 != uid.indexOf(37) ? new RangePatternDefinedSupplier(uid) : new ConstantStringSupplier(uid));
        String authFile = this.authConfig.getFile();
        if (authFile != null && !authFile.isEmpty()) {
            Map<String, String> credentials = BasicLoadGeneratorBuilder.loadCredentials(authFile, this.loadConfig.getQueueConfig().getSize());
            ioTaskBuilder.setCredentialsMap(credentials);
        } else {
            String secret = this.authConfig.getSecret();
            ConstantStringSupplier secretSupplier = secret == null ? null : new ConstantStringSupplier(secret);
            ioTaskBuilder.setSecretSupplier((BatchSupplier)secretSupplier);
        }
        ioTaskBuilder.setIoType(IoType.valueOf((String)this.loadConfig.getType().toUpperCase())).setInputPath(itemInputPath).setOutputPathSupplier(outputPathSupplier).setUidSupplier((BatchSupplier)uidSupplier);
        String itemInputFile = inputConfig.getFile();
        if (this.itemInput == null) {
            this.itemInput = this.getItemInput(ioType, itemInputFile, itemInputPath);
            if (this.itemInput == null) {
                throw new UserShootHisFootException("No item input available");
            }
            this.sizeEstimate = ItemType.DATA.equals((Object)this.itemType) ? BasicLoadGeneratorBuilder.estimateTransferSize((DataIoTaskBuilder)ioTaskBuilder, ioTaskBuilder.getIoType(), this.itemInput) : 4096L;
        }
        if (this.sizeEstimate != 0L && ItemType.DATA.equals((Object)this.itemType)) {
            for (StorageDriver<I, O> storageDriver : this.storageDrivers) {
                try {
                    storageDriver.adjustIoBuffers(this.sizeEstimate, ioType);
                }
                catch (RemoteException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to adjust the storage driver buffer sizes", (Object[])new Object[0]);
                }
            }
        }
        return (T)((Object)new BasicLoadGenerator(this.itemInput, this.batchSize, this.sizeEstimate, ioTaskBuilder, countLimit, sizeLimit, shuffleFlag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long estimateTransferSize(DataIoTaskBuilder dataIoTaskBuilder, IoType ioType, Input<DataItem> itemInput) {
        int n;
        long sizeThreshold = 0L;
        int randomRangesCount = 0;
        List fixedRanges = null;
        if (dataIoTaskBuilder != null) {
            sizeThreshold = dataIoTaskBuilder.getSizeThreshold();
            randomRangesCount = dataIoTaskBuilder.getRandomRangesCount();
            fixedRanges = dataIoTaskBuilder.getFixedRanges();
        }
        long itemSize = 0L;
        int maxCount = 256;
        ArrayList items = new ArrayList(256);
        try {
            for (n = 0; n < 256; n += itemInput.get(items, 256 - n)) {
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to estimate the average data item size", (Object[])new Object[0]);
        }
        finally {
            try {
                itemInput.reset();
            }
            catch (IOException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed reset the items input", (Object[])new Object[0]);
            }
        }
        long sumSize = 0L;
        long minSize = Long.MAX_VALUE;
        long maxSize = Long.MIN_VALUE;
        if (n > 0) {
            try {
                for (int i = 0; i < n; ++i) {
                    long nextSize = ((DataItem)items.get(i)).size();
                    sumSize += nextSize;
                    if (nextSize < minSize) {
                        minSize = nextSize;
                    }
                    if (nextSize <= maxSize) continue;
                    maxSize = nextSize;
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            itemSize = minSize == maxSize ? sumSize / (long)n : (minSize + maxSize) / 2L;
        }
        switch (ioType) {
            case CREATE: {
                return Math.min(itemSize, sizeThreshold);
            }
            case READ: 
            case UPDATE: {
                if (randomRangesCount > 0) {
                    return itemSize * (long)randomRangesCount / (long)DataItem.getRangeCount((long)itemSize);
                }
                if (fixedRanges != null && !fixedRanges.isEmpty()) {
                    long sizeSum = 0L;
                    for (ByteRange byteRange : fixedRanges) {
                        long rangeSize = byteRange.getSize();
                        if (rangeSize == -1L) {
                            rangeSize = byteRange.getEnd() - byteRange.getBeg() + 1L;
                        }
                        if (rangeSize <= 0L) continue;
                        sizeSum += rangeSize;
                    }
                    return sizeSum;
                }
                return itemSize;
            }
        }
        return 0L;
    }

    private BatchSupplier<String> getOutputPathSupplier() throws UserShootHisFootException {
        String path = this.itemConfig.getOutputConfig().getPath();
        if (path == null || path.isEmpty()) {
            path = LogUtil.getDateTimeStamp();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        Object pathSupplier = -1 == path.indexOf(37) ? new ConstantStringSupplier(path) : new RangePatternDefinedSupplier(path);
        return pathSupplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Input<I> getItemInput(IoType ioType, String itemInputFile, String itemInputPath) throws UserShootHisFootException {
        if (itemInputFile == null || itemInputFile.isEmpty()) {
            Config.ItemConfig.NamingConfig namingConfig = this.itemConfig.getNamingConfig();
            ItemNamingType namingType = ItemNamingType.valueOf((String)namingConfig.getType().toUpperCase());
            String namingPrefix = namingConfig.getPrefix();
            int namingLength = namingConfig.getLength();
            int namingRadix = namingConfig.getRadix();
            long namingOffset = namingConfig.getOffset();
            if (itemInputPath == null || itemInputPath.isEmpty()) {
                if (!IoType.CREATE.equals((Object)ioType) && !IoType.NOOP.equals((Object)ioType)) throw new UserShootHisFootException("No input (file either path) is specified for non-create generator");
                ItemNameSupplier itemNameInput = new ItemNameSupplier(namingType, namingPrefix, namingLength, namingRadix, namingOffset);
                if (this.itemFactory instanceof BasicDataItemFactory) {
                    SizeInBytes size = this.itemConfig.getDataConfig().getSize();
                    this.itemInput = new NewDataItemInput(this.itemFactory, (IdStringInput)itemNameInput, size);
                    return this.itemInput;
                } else {
                    this.itemInput = new NewItemInput(this.itemFactory, (IdStringInput)itemNameInput);
                }
                return this.itemInput;
            } else {
                this.itemInput = new StorageItemInput<I>(this.storageDrivers.get(0), this.batchSize, this.itemFactory, itemInputPath, namingPrefix, namingRadix);
            }
            return this.itemInput;
        }
        try {
            this.itemInput = new CsvFileItemInput(Paths.get(itemInputFile, new String[0]), this.itemFactory);
            return this.itemInput;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to use the item input file \"{}\"", (Object[])new Object[]{itemInputFile});
        }
        return this.itemInput;
    }

    private static Map<String, String> loadCredentials(String file, long countLimit) throws UserShootHisFootException {
        HashMap<String, String> credentials = new HashMap<String, String>();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(file, new String[0]));){
            String line;
            long count = 0L;
            while (null != (line = br.readLine()) && count < countLimit) {
                int firstCommaPos = line.indexOf(44);
                if (-1 == firstCommaPos) {
                    Loggers.ERR.warn("Invalid credentials line: \"{}\"", (Object)line);
                    continue;
                }
                String[] parts = line.split(",", 2);
                credentials.put(parts[0], parts[1]);
                ++count;
            }
            Loggers.MSG.info("Loaded {} credential pairs from the file \"{}\"", (Object)credentials.size(), (Object)file);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to load the credentials from the file \"{}\"", (Object[])new Object[]{file});
        }
        return credentials;
    }
}

