/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.generator;

import com.emc.mongoose.common.io.collection.BufferingInputBase;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.item.DataItemFactory;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.model.item.ItemFactory;
import com.emc.mongoose.model.storage.StorageDriver;
import java.io.IOException;
import java.util.List;

public final class StorageItemInput<I extends Item>
extends BufferingInputBase<I> {
    private final StorageDriver<I, ? extends IoTask<I>> storageDriver;
    private final ItemFactory<I> itemFactory;
    private final String path;
    private final String prefix;
    private final int idRadix;

    public StorageItemInput(StorageDriver<I, ? extends IoTask<I>> storageDriver, int batchSize, ItemFactory<I> itemFactory, String path, String prefix, int idRadix) {
        super(batchSize);
        this.storageDriver = storageDriver;
        this.itemFactory = itemFactory;
        this.path = path;
        this.prefix = prefix;
        this.idRadix = idRadix;
    }

    protected final int loadMoreItems(I lastItem) throws IOException {
        List newItems = this.storageDriver.list(this.itemFactory, this.path, this.prefix, this.idRadix, lastItem, this.capacity);
        for (Item item : newItems) {
            this.items.add(item);
        }
        return this.items.size();
    }

    public final String toString() {
        return (this.itemFactory instanceof DataItemFactory ? "Data" : "") + "ItemsFromPath(" + this.path + ")";
    }
}

