/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.step.linear;

import com.emc.mongoose.data.DataInput;
import com.emc.mongoose.env.Extension;
import com.emc.mongoose.exception.InterruptRunException;
import com.emc.mongoose.exception.OmgShootMyFootException;
import com.emc.mongoose.item.ItemFactory;
import com.emc.mongoose.item.ItemType;
import com.emc.mongoose.item.io.ItemInfoFileOutput;
import com.emc.mongoose.item.op.OpType;
import com.emc.mongoose.load.generator.LoadGenerator;
import com.emc.mongoose.load.generator.LoadGeneratorBuilderImpl;
import com.emc.mongoose.load.step.local.LoadStepLocalBase;
import com.emc.mongoose.load.step.local.context.LoadStepContextImpl;
import com.emc.mongoose.logging.LogUtil;
import com.emc.mongoose.logging.Loggers;
import com.emc.mongoose.metrics.MetricsManager;
import com.emc.mongoose.metrics.context.MetricsContext;
import com.emc.mongoose.storage.driver.StorageDriver;
import com.github.akurilov.commons.concurrent.throttle.RateThrottle;
import com.github.akurilov.commons.concurrent.throttle.Throttle;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.Level;

public class LinearLoadStepLocal
extends LoadStepLocalBase {
    public LinearLoadStepLocal(Config baseConfig, List<Extension> extensions, List<Config> contexts, MetricsManager metricsManager) {
        super(baseConfig, extensions, contexts, metricsManager);
    }

    public String getTypeName() {
        return "Load";
    }

    protected void init() throws InterruptRunException {
        String autoStepId = "linear_" + LogUtil.getDateTimeStamp();
        if (this.config.boolVal("load-step-idAutoGenerated")) {
            this.config.val("load-step-id", (Object)autoStepId);
        }
        Config loadConfig = this.config.configVal("load");
        Config opConfig = loadConfig.configVal("op");
        Config stepConfig = loadConfig.configVal("step");
        OpType opType = OpType.valueOf((String)opConfig.stringVal("type").toUpperCase());
        Config storageConfig = this.config.configVal("storage");
        int concurrencyLimit = storageConfig.intVal("driver-limit-concurrency");
        Config outputConfig = this.config.configVal("output");
        Config metricsConfig = outputConfig.configVal("metrics");
        Object itemDataSizeRaw = this.config.val("item-data-size");
        SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(((Long)TypeUtil.typeConvert((Object)itemDataSizeRaw, Long.TYPE)).longValue());
        boolean originIndex = false;
        boolean outputColorFlag = outputConfig.boolVal("color");
        this.initMetrics(0, opType, concurrencyLimit, metricsConfig, itemDataSize, outputColorFlag);
        Config itemConfig = this.config.configVal("item");
        Config dataConfig = itemConfig.configVal("data");
        Config dataInputConfig = dataConfig.configVal("input");
        Config dataLayerConfig = dataInputConfig.configVal("layer");
        String testStepId = stepConfig.stringVal("id");
        try {
            Object dataLayerSizeRaw = dataLayerConfig.val("size");
            SizeInBytes dataLayerSize = dataLayerSizeRaw instanceof String ? new SizeInBytes((String)dataLayerSizeRaw) : new SizeInBytes((long)((Integer)TypeUtil.typeConvert((Object)dataLayerSizeRaw, Integer.TYPE)).intValue());
            DataInput dataInput = DataInput.instance((String)dataInputConfig.stringVal("file"), (String)dataInputConfig.stringVal("seed"), (SizeInBytes)dataLayerSize, (int)dataLayerConfig.intVal("cache"));
            int batchSize = loadConfig.intVal("batch-size");
            try {
                StorageDriver driver = StorageDriver.instance((List)this.extensions, (Config)storageConfig, (DataInput)dataInput, (boolean)dataConfig.boolVal("verify"), (int)batchSize, (String)testStepId);
                ItemType itemType = ItemType.valueOf((String)itemConfig.stringVal("type").toUpperCase());
                ItemFactory itemFactory = ItemType.getItemFactory((ItemType)itemType);
                double rateLimit = opConfig.doubleVal("limit-rate");
                try {
                    LoadGeneratorBuilderImpl generatorBuilder = new LoadGeneratorBuilderImpl().itemConfig(itemConfig).loadConfig(loadConfig).itemType(itemType).itemFactory(itemFactory).storageDriver(driver).authConfig(storageConfig.configVal("auth")).originIndex(0);
                    if (rateLimit > 0.0) {
                        generatorBuilder.addThrottle((Throttle)new RateThrottle(rateLimit));
                    }
                    LoadGenerator generator = generatorBuilder.build();
                    LoadStepContextImpl stepCtx = new LoadStepContextImpl(testStepId, generator, driver, (MetricsContext)this.metricsContexts.get(0), loadConfig, outputConfig.boolVal("metrics-trace-persist"));
                    this.stepContexts.add(stepCtx);
                    String itemOutputFile = itemConfig.stringVal("output-file");
                    if (itemOutputFile != null && itemOutputFile.length() > 0) {
                        Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                        if (Files.exists(itemOutputPath, new LinkOption[0])) {
                            Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                        }
                        try {
                            ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                            stepCtx.operationsResultsOutput((Output)itemOutput);
                        }
                        catch (IOException e) {
                            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to initialize the item output, the processed items info won't be persisted", (Object[])new Object[0]);
                        }
                    }
                }
                catch (OmgShootMyFootException e) {
                    throw new IllegalStateException("Failed to initialize the load generator", e);
                }
            }
            catch (OmgShootMyFootException e) {
                throw new IllegalStateException("Failed to initialize the storage driver", e);
            }
            catch (InterruptedException e) {
                throw new InterruptRunException((Throwable)e);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the data input", e);
        }
    }
}

