/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.step.weighted;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.client.LoadStepClient;
import com.emc.mongoose.base.load.step.client.LoadStepClientBase;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.github.akurilov.commons.collection.TreeUtil;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.exceptions.InvalidValuePathException;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class WeightedLoadStepClient
extends LoadStepClientBase {
    public WeightedLoadStepClient(Config config, List<Extension> extensions, List<Config> ctxConfigs, MetricsManager metricsManager) {
        super(config, extensions, ctxConfigs, metricsManager);
    }

    public String getTypeName() {
        return "WeightedLoad";
    }

    protected <T extends LoadStepClient> T copyInstance(Config config, List<Config> ctxConfigs) {
        return (T)((Object)new WeightedLoadStepClient(config, this.extensions, ctxConfigs, this.metricsMgr));
    }

    protected void init() throws IllegalStateException {
        String autoStepId = "weighted_" + LogUtil.getDateTimeStamp();
        Config stepConfig = this.config.configVal("load-step");
        if (stepConfig.boolVal("idAutoGenerated")) {
            stepConfig.val("id", (Object)autoStepId);
        }
        int subStepCount = this.ctxConfigs.size();
        for (int originIndex = 0; originIndex < subStepCount; ++originIndex) {
            Map mergedConfigTree = TreeUtil.reduceForest(Arrays.asList(Config.deepToMap((Config)this.config), Config.deepToMap((Config)((Config)this.ctxConfigs.get(originIndex)))));
            BasicConfig subConfig = null;
            try {
                subConfig = new BasicConfig(this.config.pathSep(), this.config.schema(), mergedConfigTree);
            }
            catch (InvalidValuePathException | InvalidValueTypeException e) {
                LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Scenario syntax error", (Object[])new Object[0]);
                Exceptions.throwUnchecked((Throwable)e);
            }
            OpType opType = OpType.valueOf((String)subConfig.stringVal("load-op-type").toUpperCase());
            int concurrencyLimit = this.config.intVal("storage-driver-limit-concurrency");
            Config outputConfig = subConfig.configVal("output");
            Config metricsConfig = outputConfig.configVal("metrics");
            Object itemDataSizeRaw = subConfig.val("item-data-size");
            SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(((Long)TypeUtil.typeConvert((Object)itemDataSizeRaw, Long.TYPE)).longValue());
            boolean colorFlag = outputConfig.boolVal("color");
            this.initMetrics(originIndex, opType, concurrencyLimit, metricsConfig, itemDataSize, colorFlag);
        }
    }
}

